/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.InputStream;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTypeMappingTest;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

public class JavaParserTypeMappingTest
implements JavaTypeMappingTest,
RewriteTest {
    @Language(value="java")
    private final String goat = StringUtils.readFully((InputStream)JavaParserTypeMappingTest.class.getResourceAsStream("/JavaTypeGoat.java"));
    private final J.CompilationUnit goatCu = JavaParser.fromJavaVersion().build().parse(new String[]{this.goat}).findFirst().map(J.CompilationUnit.class::cast).orElseThrow(() -> new IllegalArgumentException("Could not parse as Java"));

    public JavaType.FullyQualified classType(final String fqn) {
        final AtomicReference type = new AtomicReference();
        new JavaVisitor<Object>(){

            public J visitClassDeclaration(J.ClassDeclaration classDecl, Object o) {
                if (Objects.requireNonNull(classDecl.getType()).getFullyQualifiedName().equals(fqn)) {
                    type.set(classDecl.getType());
                    return classDecl;
                }
                return super.visitClassDeclaration(classDecl, o);
            }
        }.visit((Tree)this.goatCu, (Object)0);
        return (JavaType.FullyQualified)type.get();
    }

    @Test
    void annotationParameterDefaults() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"@AnAnnotation\nclass Test {\n}\n@interface AnAnnotation {\n    int scalar() default 1;\n    String[] array() default {\"a\", \"b\"};\n}\n", spec -> spec.afterRecipe(cu -> {
            JavaType.Class t = TypeUtils.asClass((JavaType)((J.Annotation)((J.ClassDeclaration)cu.getClasses().get(0)).getAllAnnotations().get(0)).getType());
            org.assertj.core.api.Assertions.assertThat(t.getMethods().stream().filter(m -> m.getName().equals("scalar")).map(JavaType.Method::getDefaultValue).map(dv -> (String)dv.get(0))).containsExactly((Object[])new String[]{"1"});
            org.assertj.core.api.Assertions.assertThat(t.getMethods().stream().filter(m -> m.getName().equals("array")).map(JavaType.Method::getDefaultValue).flatMap(dv -> dv.stream())).hasSize(2);
        }))});
    }

    @Test
    void parameterizedTypesAreDeeplyBasedOnBounds() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"abstract class TypeA<T extends Number> extends java.util.ArrayList<T> {}", spec -> spec.afterRecipe(cu -> {
            JavaType.Parameterized typeA = TypeUtils.asParameterized((JavaType)((J.ClassDeclaration)cu.getClasses().get(0)).getType());
            org.assertj.core.api.Assertions.assertThat((String)TypeUtils.asGeneric((JavaType)((JavaType)typeA.getTypeParameters().get(0))).toString()).isEqualTo("Generic{T extends java.lang.Number}");
            JavaType.Parameterized typeASuperType = TypeUtils.asParameterized((JavaType)typeA.getSupertype());
            org.assertj.core.api.Assertions.assertThat((String)typeASuperType.toString()).isEqualTo("java.util.ArrayList<Generic{T extends java.lang.Number}>");
            org.assertj.core.api.Assertions.assertThat((String)((JavaType)TypeUtils.asClass((JavaType)typeASuperType.getType()).getTypeParameters().get(0)).toString()).isEqualTo("Generic{E}");
        })), Assertions.java((String)"class TypeB extends TypeA<Integer> {\n    // Attempt to force the JavaTypeCache to cache the wrong parameterized super type.\n    java.util.List<String> list = new java.util.ArrayList<>();\n}\n", spec -> spec.afterRecipe(cu -> {
            JavaType.Class typeB = TypeUtils.asClass((JavaType)((J.ClassDeclaration)cu.getClasses().get(0)).getType());
            org.assertj.core.api.Assertions.assertThat((String)typeB.getSupertype().toString()).isEqualTo("TypeA<java.lang.Integer>");
            JavaType.Parameterized typeBSuperType = TypeUtils.asParameterized((JavaType)typeB.getSupertype());
            org.assertj.core.api.Assertions.assertThat((String)((JavaType)TypeUtils.asClass((JavaType)typeBSuperType.getType()).getTypeParameters().get(0)).toString()).isEqualTo("Generic{T extends java.lang.Number}");
        })), Assertions.java((String)"class TypeC<T extends String> extends java.util.ArrayList<T> {\n    // Attempt to force the JavaTypeCache to cache the wrong parameterized super type.\n    java.util.List<Object> list = new java.util.ArrayList<>();\n}\n", spec -> spec.afterRecipe(cu -> {
            JavaType.Parameterized typeC = TypeUtils.asParameterized((JavaType)((J.ClassDeclaration)cu.getClasses().get(0)).getType());
            org.assertj.core.api.Assertions.assertThat((String)TypeUtils.asGeneric((JavaType)((JavaType)typeC.getTypeParameters().get(0))).toString()).isEqualTo("Generic{T extends java.lang.String}");
            JavaType.Parameterized typeCSuperType = TypeUtils.asParameterized((JavaType)typeC.getSupertype());
            org.assertj.core.api.Assertions.assertThat((String)typeCSuperType.toString()).isEqualTo("java.util.ArrayList<Generic{T extends java.lang.String}>");
            org.assertj.core.api.Assertions.assertThat((String)((JavaType)TypeUtils.asClass((JavaType)typeCSuperType.getType()).getTypeParameters().get(0)).toString()).isEqualTo("Generic{E}");
        }))});
    }

    @Test
    void methodInvocationWithUnknownTypeSymbol() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.ArrayList;\nimport java.util.List;\nimport java.util.stream.Collectors;\n\nclass Test {\n    class Parent {\n    }\n    class Child extends Parent {\n    }\n\n    List<Parent> method(List<Parent> values) {\n        return values.stream()\n                .map(o -> {\n                    if (o instanceof Child) {\n                        return new UnknownType(((Child) o).toString());\n                    }\n                    return o;\n                })\n                .collect(Collectors.toList());\n    }\n}\n")});
    }

    @Test
    void methodInvocationOnUnknownType() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.ArrayList;\n// do not import List to create an UnknownType\n\nclass Test {\n    class Base {\n        private int foo;\n        public boolean setFoo(int foo) {\n            this.foo = foo;\n        }\n        public int getFoo() {\n            return foo;\n        }\n    }\n    List<Base> createUnknownType(List<Integer> values) {\n        List<Base> bases = new ArrayList<>();\n        values.forEach((v) -> {\n            Base b = new Base();\n            b.setFoo(v);\n            bases.add(b);\n        });\n        return bases;\n    }\n}\n")});
    }

    @Test
    void variousMethodScopeIdentifierTypes() {
        this.rewriteRun(spec -> spec.recipe((Recipe)RewriteTest.toRecipe(() -> new JavaIsoVisitor<ExecutionContext>(){

            public J.Binary visitBinary(J.Binary binary, ExecutionContext executionContext) {
                if (binary.getLeft() instanceof J.Identifier) {
                    J.Identifier left = (J.Identifier)binary.getLeft();
                    if ("i".equals(left.getSimpleName())) {
                        org.assertj.core.api.Assertions.assertThat((String)left.getFieldType().getType().toString()).isEqualTo("java.lang.Integer");
                    } else if ("m".equals(left.getSimpleName())) {
                        org.assertj.core.api.Assertions.assertThat((String)left.getFieldType().getType().toString()).isEqualTo("MakeEasyToFind$MultiMap");
                    }
                }
                return binary;
            }

            public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext executionContext) {
                if (variable.getSimpleName().equals("l")) {
                    org.assertj.core.api.Assertions.assertThat((String)variable.getType().toString()).isEqualTo("java.lang.Long");
                }
                return super.visitVariable(variable, (Object)executionContext);
            }
        })), new SourceSpecs[]{Assertions.java((String)"import java.util.List;\nimport java.util.stream.Collectors;\n\n@SuppressWarningsWarnings(\"ALL\")\nclass MakeEasyToFind {\n    void method(List<MultiMap> multiMaps) {\n        List<Integer> ints;\n        ints.forEach(i -> {\n            if (i != null) {\n            }\n        });\n\n        multiMaps.forEach(m -> {\n            if (m != null) {\n            }\n        });\n\n        while (true) {\n            if (multiMaps.isEmpty()) {\n                Long l;\n                break;\n            }\n        }\n    }\n\n    static class MultiMap {\n        List<Inner> inners;\n        public List<Inner> getInners() {\n            return inners;\n        }\n\n        static class Inner {\n            List<Number> numbers;\n            public List<Number> getNumbers() {\n                return numbers;\n            }\n        }\n    }\n}\n")});
    }

    @Test
    void multiMapWithSameLambdaParamNames() {
        this.rewriteRun(spec -> spec.recipe((Recipe)RewriteTest.toRecipe(() -> new JavaIsoVisitor<ExecutionContext>(){

            public J.Lambda visitLambda(J.Lambda lambda, ExecutionContext executionContext) {
                J.Identifier param = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)lambda.getParameters().getParameters().get(0)).getVariables().get(0)).getName();
                if ("it1".equals(param.getSimpleName())) {
                    org.assertj.core.api.Assertions.assertThat((String)param.getType().toString()).isEqualTo("MakeEasyToFind$MultiMap");
                } else if ("it2".equals(param.getSimpleName())) {
                    org.assertj.core.api.Assertions.assertThat((String)((JavaType)TypeUtils.asParameterized((JavaType)param.getType()).getTypeParameters().get(0)).toString()).isEqualTo("MakeEasyToFind$MultiMap$Inner");
                }
                return super.visitLambda(lambda, (Object)executionContext);
            }
        })), new SourceSpecs[]{Assertions.java((String)"import java.util.List;\nimport java.util.stream.Collectors;\n\n@SuppressWarningsWarnings(\"ALL\")\nclass MakeEasyToFind {\n    void method(List<MultiMap> multiMaps) {\n        Object obj = multiMaps.stream()\n            .map(it1 -> it1.getInners())\n            .map(it2 -> it2.stream().map(i -> i.getNumbers()))\n            .collect(Collectors.toList());\n    }\n\n    static class MultiMap {\n        List<Inner> inners;\n        public List<Inner> getInners() {\n            return inners;\n        }\n\n        static class Inner {\n            List<Number> numbers;\n            public List<Number> getNumbers() {\n                return numbers;\n            }\n        }\n    }\n}\n")});
    }
}

