/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hcl.tree;

import java.util.Comparator;
import org.openrewrite.hcl.tree.BodyContent;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.hcl.tree.HclCoordinates;
import org.openrewrite.hcl.tree.Space;

public abstract class CoordinateBuilder {
    Hcl tree;

    CoordinateBuilder(Hcl tree) {
        this.tree = tree;
    }

    HclCoordinates before(Space.Location location) {
        return new HclCoordinates(this.tree, location, HclCoordinates.Mode.BEFORE, null);
    }

    HclCoordinates after(Space.Location location) {
        return new HclCoordinates(this.tree, location, HclCoordinates.Mode.AFTER, null);
    }

    HclCoordinates replace(Space.Location location) {
        return new HclCoordinates(this.tree, location, HclCoordinates.Mode.REPLACEMENT, null);
    }

    public static class ConfigFile
    extends CoordinateBuilder {
        ConfigFile(Hcl.ConfigFile tree) {
            super(tree);
        }

        public HclCoordinates last() {
            return this.before(Space.Location.CONFIG_FILE_EOF);
        }

        public HclCoordinates add(Comparator<BodyContent> idealOrdering) {
            return new HclCoordinates(this.tree, Space.Location.CONFIG_FILE_EOF, HclCoordinates.Mode.BEFORE, idealOrdering);
        }

        public HclCoordinates first() {
            return this.before(Space.Location.CONFIG_FILE);
        }
    }

    public static class Block
    extends Expression {
        Block(Hcl.Block tree) {
            super(tree);
        }

        public HclCoordinates last() {
            return this.before(Space.Location.BLOCK_CLOSE);
        }

        public HclCoordinates add(Comparator<BodyContent> idealOrdering) {
            return new HclCoordinates(this.tree, Space.Location.BLOCK_CLOSE, HclCoordinates.Mode.BEFORE, idealOrdering);
        }

        @Override
        public HclCoordinates replace() {
            return this.replace(Space.Location.BLOCK);
        }
    }

    public static class Expression
    extends CoordinateBuilder {
        Expression(org.openrewrite.hcl.tree.Expression tree) {
            super(tree);
        }

        public HclCoordinates replace() {
            return this.replace(Space.Location.EXPRESSION_PREFIX);
        }
    }
}

