/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hcl.format;

import org.openrewrite.hcl.HclIsoVisitor;
import org.openrewrite.hcl.tree.Expression;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.hcl.tree.Space;
import org.openrewrite.internal.ListUtils;

public class NormalizeFormatVisitor<P>
extends HclIsoVisitor<P> {
    @Override
    public Hcl.Attribute visitAttribute(Hcl.Attribute attribute, P p) {
        Hcl a = super.visitAttribute(attribute, (Object)p);
        if (((Hcl.Attribute)a).getName().getPrefix() != Space.EMPTY) {
            a = (Hcl.Attribute)this.concatenateSpace(a, ((Hcl.Attribute)a).getName().getPrefix());
            a = ((Hcl.Attribute)a).withName((Expression)((Hcl.Attribute)a).getName().withPrefix(Space.EMPTY));
        }
        return a;
    }

    @Override
    public Hcl.AttributeAccess visitAttributeAccess(Hcl.AttributeAccess attributeAccess, P p) {
        Hcl a = super.visitAttributeAccess(attributeAccess, (Object)p);
        if (((Hcl.AttributeAccess)a).getAttribute().getPrefix() != Space.EMPTY) {
            a = (Hcl.AttributeAccess)this.concatenateSpace(a, ((Hcl.AttributeAccess)a).getAttribute().getPrefix());
            a = ((Hcl.AttributeAccess)a).withAttribute((Expression)((Hcl.AttributeAccess)a).getAttribute().withPrefix(Space.EMPTY));
        }
        return a;
    }

    @Override
    public Hcl.Binary visitBinary(Hcl.Binary binary, P p) {
        Hcl b = super.visitBinary(binary, (Object)p);
        if (((Hcl.Binary)b).getLeft().getPrefix() != Space.EMPTY) {
            b = (Hcl.Binary)this.concatenateSpace(b, ((Hcl.Binary)b).getLeft().getPrefix());
            b = ((Hcl.Binary)b).withLeft((Expression)((Hcl.Binary)b).getLeft().withPrefix(Space.EMPTY));
        }
        return b;
    }

    @Override
    public Hcl.Block visitBlock(Hcl.Block block, P p) {
        Hcl b = super.visitBlock(block, (Object)p);
        Hcl.Identifier type = ((Hcl.Block)b).getType();
        if (type != null && type.getPrefix() != Space.EMPTY) {
            b = (Hcl.Block)this.concatenateSpace(b, type.getPrefix());
            b = ((Hcl.Block)b).withType(type.withPrefix(Space.EMPTY));
        }
        return b;
    }

    @Override
    public Hcl.Conditional visitConditional(Hcl.Conditional conditional, P p) {
        Hcl c = super.visitConditional(conditional, (Object)p);
        if (((Hcl.Conditional)c).getCondition().getPrefix() != Space.EMPTY) {
            c = (Hcl.Conditional)this.concatenateSpace(c, ((Hcl.Conditional)c).getCondition().getPrefix());
            c = ((Hcl.Conditional)c).withCondition((Expression)((Hcl.Conditional)c).getCondition().withPrefix(Space.EMPTY));
        }
        return c;
    }

    @Override
    public Hcl.ConfigFile visitConfigFile(Hcl.ConfigFile configFile, P p) {
        Hcl c = super.visitConfigFile(configFile, (Object)p);
        if (Space.firstPrefix(((Hcl.ConfigFile)c).getBody()) != Space.EMPTY) {
            c = (Hcl.ConfigFile)this.concatenateSpace(c, Space.firstPrefix(((Hcl.ConfigFile)c).getBody()));
            c = ((Hcl.ConfigFile)c).withBody(Space.formatFirstPrefix(((Hcl.ConfigFile)c).getBody(), Space.EMPTY));
        }
        return c;
    }

    @Override
    public Hcl.FunctionCall visitFunctionCall(Hcl.FunctionCall functionCall, P p) {
        Hcl f = super.visitFunctionCall(functionCall, (Object)p);
        if (((Hcl.FunctionCall)f).getName().getPrefix() != Space.EMPTY) {
            f = (Hcl.FunctionCall)this.concatenateSpace(f, ((Hcl.FunctionCall)f).getName().getPrefix());
            f = ((Hcl.FunctionCall)f).withName(((Hcl.FunctionCall)f).getName().withPrefix(Space.EMPTY));
        }
        return f;
    }

    @Override
    public Hcl.Index visitIndex(Hcl.Index index, P p) {
        Hcl i = super.visitIndex(index, (Object)p);
        if (((Hcl.Index)i).getIndexed().getPrefix() != Space.EMPTY) {
            i = (Hcl.Index)this.concatenateSpace(i, ((Hcl.Index)i).getIndexed().getPrefix());
            i = ((Hcl.Index)i).withIndexed((Expression)((Hcl.Index)i).getIndexed().withPrefix(Space.EMPTY));
        }
        return i;
    }

    @Override
    public Hcl.Unary visitUnary(Hcl.Unary unary, P p) {
        Hcl u = super.visitUnary(unary, (Object)p);
        if (((Hcl.Unary)u).getExpression().getPrefix() != Space.EMPTY) {
            u = (Hcl.Unary)this.concatenateSpace(u, ((Hcl.Unary)u).getExpression().getPrefix());
            u = ((Hcl.Unary)u).withExpression((Expression)((Hcl.Unary)u).getExpression().withPrefix(Space.EMPTY));
        }
        return u;
    }

    @Override
    public Hcl.VariableExpression visitVariableExpression(Hcl.VariableExpression variableExpression, P p) {
        Hcl v = super.visitVariableExpression(variableExpression, (Object)p);
        if (((Hcl.VariableExpression)v).getName().getPrefix() != Space.EMPTY) {
            v = (Hcl.VariableExpression)this.concatenateSpace(v, ((Hcl.VariableExpression)v).getName().getPrefix());
            v = ((Hcl.VariableExpression)v).withName(((Hcl.VariableExpression)v).getName().withPrefix(Space.EMPTY));
        }
        return v;
    }

    private <H extends Hcl> H concatenateSpace(H h, Space prefix) {
        H h2 = h;
        h2 = h2.getPrefix().getComments().isEmpty() ? h2.withPrefix(h2.getPrefix().withWhitespace(h2.getPrefix().getWhitespace() + prefix.getWhitespace())) : h2.withPrefix(h2.getPrefix().withComments(ListUtils.mapLast(h2.getPrefix().getComments(), c -> c.withSuffix(c.getSuffix() + prefix.getWhitespace()))));
        if (!prefix.getComments().isEmpty()) {
            h2 = h2.withPrefix(h2.getPrefix().withComments(ListUtils.concatAll(h2.getPrefix().getComments(), prefix.getComments())));
        }
        return h2;
    }
}

