/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.util.ChangeStringLiteral;
import org.openrewrite.gradle.util.Dependency;
import org.openrewrite.gradle.util.DependencyStringNotationConverter;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.semver.DependencyMatcher;

public final class ChangeDependencyGroupId
extends Recipe {
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="com.fasterxml.jackson*")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="jackson-module*")
    private final String artifactId;
    @Option(displayName="New groupId", description="The new groupId to use.", example="corp.internal.jackson")
    private final String newGroupId;
    @Option(displayName="Dependency configuration", description="The dependency configuration to search for dependencies in.", example="api", required=false)
    @Nullable
    private final String configuration;

    public String getDisplayName() {
        return "Change Gradle dependency group";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s:%s`", this.groupId, this.artifactId);
    }

    public String getDescription() {
        return "Change the group of a specified Gradle dependency.";
    }

    public Validated<Object> validate() {
        return super.validate().and(DependencyMatcher.build((String)(this.groupId + ":" + this.artifactId)));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new IsBuildGradle(), (TreeVisitor)new GroovyVisitor<ExecutionContext>(){
            final DependencyMatcher depMatcher;
            final MethodMatcher dependencyDsl;
            final Map<GroupArtifact, GroupArtifact> updatedDependencies;
            {
                this.depMatcher = Objects.requireNonNull((DependencyMatcher)DependencyMatcher.build((String)(ChangeDependencyGroupId.this.groupId + ":" + ChangeDependencyGroupId.this.artifactId)).getValue());
                this.dependencyDsl = new MethodMatcher("DependencyHandlerSpec *(..)");
                this.updatedDependencies = new HashMap<GroupArtifact, GroupArtifact>();
            }

            public G visitCompilationUnit(G.CompilationUnit compilationUnit, ExecutionContext ctx) {
                G.CompilationUnit cu = (G.CompilationUnit)super.visitCompilationUnit(compilationUnit, (Object)ctx);
                if (cu != compilationUnit) {
                    cu = cu.withMarkers(cu.getMarkers().withMarkers(ListUtils.map((List)cu.getMarkers().getMarkers(), m -> {
                        if (m instanceof GradleProject) {
                            return ChangeDependencyGroupId.this.updateModel((GradleProject)m, this.updatedDependencies);
                        }
                        return m;
                    })));
                }
                return cu;
            }

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (!this.dependencyDsl.matches((MethodCall)m) || !StringUtils.isBlank((String)ChangeDependencyGroupId.this.configuration) && !m.getSimpleName().equals(ChangeDependencyGroupId.this.configuration)) {
                    return m;
                }
                List depArgs = m.getArguments();
                if (depArgs.get(0) instanceof J.Literal || depArgs.get(0) instanceof G.GString || depArgs.get(0) instanceof G.MapEntry) {
                    m = this.updateDependency(m);
                } else if (depArgs.get(0) instanceof J.MethodInvocation && (((J.MethodInvocation)depArgs.get(0)).getSimpleName().equals("platform") || ((J.MethodInvocation)depArgs.get(0)).getSimpleName().equals("enforcedPlatform"))) {
                    m = m.withArguments(ListUtils.mapFirst((List)depArgs, platform -> this.updateDependency((J.MethodInvocation)platform)));
                }
                return m;
            }

            private J.MethodInvocation updateDependency(J.MethodInvocation m) {
                List depArgs = m.getArguments();
                if (depArgs.get(0) instanceof J.Literal) {
                    Dependency dependency;
                    String gav = (String)((J.Literal)depArgs.get(0)).getValue();
                    if (gav != null && (dependency = DependencyStringNotationConverter.parse(gav)) != null && !ChangeDependencyGroupId.this.newGroupId.equals(dependency.getGroupId()) && (dependency.getVersion() == null && this.depMatcher.matches(dependency.getGroupId(), dependency.getArtifactId()) || dependency.getVersion() != null && this.depMatcher.matches(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion()))) {
                        Dependency newDependency = dependency.withGroupId(ChangeDependencyGroupId.this.newGroupId);
                        this.updatedDependencies.put(dependency.getGav().asGroupArtifact(), newDependency.getGav().asGroupArtifact());
                        m = m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> ChangeStringLiteral.withStringValue((J.Literal)arg, newDependency.toStringNotation())));
                    }
                } else if (depArgs.get(0) instanceof G.GString) {
                    Dependency dependency;
                    List strings = ((G.GString)depArgs.get(0)).getStrings();
                    if (strings.size() >= 2 && strings.get(0) instanceof J.Literal && (dependency = DependencyStringNotationConverter.parse((String)Objects.requireNonNull(((J.Literal)strings.get(0)).getValue()))) != null && !ChangeDependencyGroupId.this.newGroupId.equals(dependency.getGroupId()) && this.depMatcher.matches(dependency.getGroupId(), dependency.getArtifactId())) {
                        Dependency newDependency = dependency.withGroupId(ChangeDependencyGroupId.this.newGroupId);
                        this.updatedDependencies.put(dependency.getGav().asGroupArtifact(), newDependency.getGav().asGroupArtifact());
                        String replacement = newDependency.toStringNotation();
                        m = m.withArguments(ListUtils.mapFirst((List)depArgs, arg -> {
                            G.GString gString = (G.GString)arg;
                            return gString.withStrings(ListUtils.mapFirst((List)gString.getStrings(), l -> ((J.Literal)l).withValue((Object)replacement).withValueSource(replacement)));
                        }));
                    }
                } else if (depArgs.get(0) instanceof G.MapEntry) {
                    G.MapEntry groupEntry = null;
                    String groupId = null;
                    String artifactId = null;
                    String version = null;
                    String versionStringDelimiter = "'";
                    for (Expression e : depArgs) {
                        G.MapEntry arg2;
                        if (!(e instanceof G.MapEntry) || !((arg2 = (G.MapEntry)e).getKey() instanceof J.Literal) || !(arg2.getValue() instanceof J.Literal)) continue;
                        J.Literal key = (J.Literal)arg2.getKey();
                        J.Literal value = (J.Literal)arg2.getValue();
                        if (!(key.getValue() instanceof String) || !(value.getValue() instanceof String)) continue;
                        String keyValue = (String)key.getValue();
                        String valueValue = (String)value.getValue();
                        if ("group".equals(keyValue) && !ChangeDependencyGroupId.this.newGroupId.equals(valueValue)) {
                            if (value.getValueSource() != null) {
                                versionStringDelimiter = value.getValueSource().substring(0, value.getValueSource().indexOf(valueValue));
                            }
                            groupEntry = arg2;
                            groupId = valueValue;
                            continue;
                        }
                        if ("name".equals(keyValue)) {
                            artifactId = valueValue;
                            continue;
                        }
                        if (!"version".equals(keyValue)) continue;
                        version = valueValue;
                    }
                    if (groupId == null || artifactId == null || version == null && !this.depMatcher.matches(groupId, artifactId) || version != null && !this.depMatcher.matches(groupId, artifactId, version)) {
                        return m;
                    }
                    String delimiter = versionStringDelimiter;
                    G.MapEntry finalGroup = groupEntry;
                    m = m.withArguments(ListUtils.map((List)m.getArguments(), arg -> {
                        if (arg == finalGroup) {
                            return finalGroup.withValue((Expression)((J.Literal)finalGroup.getValue()).withValue((Object)ChangeDependencyGroupId.this.newGroupId).withValueSource(delimiter + ChangeDependencyGroupId.this.newGroupId + delimiter));
                        }
                        return arg;
                    }));
                }
                return m;
            }
        });
    }

    private GradleProject updateModel(GradleProject gp, Map<GroupArtifact, GroupArtifact> updatedDependencies) {
        Map<String, GradleDependencyConfiguration> nameToConfigurations = gp.getNameToConfiguration();
        HashMap<String, GradleDependencyConfiguration> updatedNameToConfigurations = new HashMap<String, GradleDependencyConfiguration>();
        for (Map.Entry<String, GradleDependencyConfiguration> nameToConfiguration : nameToConfigurations.entrySet()) {
            String configurationName = nameToConfiguration.getKey();
            GradleDependencyConfiguration configuration = nameToConfiguration.getValue();
            List<org.openrewrite.maven.tree.Dependency> newRequested = configuration.getRequested().stream().map(requested -> requested.withGav(requested.getGav().withGroupArtifact(updatedDependencies.getOrDefault(requested.getGav().asGroupArtifact(), requested.getGav().asGroupArtifact())))).collect(Collectors.toList());
            List<ResolvedDependency> newResolved = configuration.getResolved().stream().map(resolved -> resolved.withGav(resolved.getGav().withGroupArtifact(updatedDependencies.getOrDefault(resolved.getGav().asGroupArtifact(), resolved.getGav().asGroupArtifact())))).collect(Collectors.toList());
            updatedNameToConfigurations.put(configurationName, configuration.withRequested(newRequested).withDirectResolved(newResolved));
        }
        return gp.withNameToConfiguration(updatedNameToConfigurations);
    }

    public ChangeDependencyGroupId(String groupId, String artifactId, String newGroupId, @Nullable String configuration) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.newGroupId = newGroupId;
        this.configuration = configuration;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getNewGroupId() {
        return this.newGroupId;
    }

    @Nullable
    public String getConfiguration() {
        return this.configuration;
    }

    @NonNull
    public String toString() {
        return "ChangeDependencyGroupId(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", newGroupId=" + this.getNewGroupId() + ", configuration=" + this.getConfiguration() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeDependencyGroupId)) {
            return false;
        }
        ChangeDependencyGroupId other = (ChangeDependencyGroupId)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$newGroupId = this.getNewGroupId();
        String other$newGroupId = other.getNewGroupId();
        if (this$newGroupId == null ? other$newGroupId != null : !this$newGroupId.equals(other$newGroupId)) {
            return false;
        }
        String this$configuration = this.getConfiguration();
        String other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeDependencyGroupId;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $newGroupId = this.getNewGroupId();
        result = result * 59 + ($newGroupId == null ? 43 : $newGroupId.hashCode());
        String $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        return result;
    }
}

