/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.tree.ParseError;
import org.openrewrite.tree.ParsingExecutionContextView;

public interface Parser {
    @Incubating(since="8.2.0")
    default public SourceFile requirePrintEqualsInput(SourceFile sourceFile, Input input, @Nullable Path relativeTo, ExecutionContext ctx) {
        if (ctx.getMessage("org.openrewrite.requirePrintEqualsInput", true).booleanValue() && !sourceFile.printEqualsInput(input, ctx)) {
            return ParseError.build(this, input, relativeTo, ctx, new IllegalStateException(sourceFile.getSourcePath() + " is not print idempotent.")).withErroneous(sourceFile);
        }
        return sourceFile;
    }

    default public Stream<SourceFile> parse(Iterable<Path> sourceFiles, @Nullable Path relativeTo, ExecutionContext ctx) {
        return this.parseInputs(StreamSupport.stream(sourceFiles.spliterator(), false).map(sourceFile -> new Input((Path)sourceFile, () -> {
            try {
                return new BufferedInputStream(Files.newInputStream(sourceFile, new OpenOption[0]));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        })).collect(Collectors.toList()), relativeTo, ctx);
    }

    default public Stream<SourceFile> parse(String ... sources) {
        return this.parse(new InMemoryExecutionContext(), sources);
    }

    default public Stream<SourceFile> parse(ExecutionContext ctx, String ... sources) {
        return this.parseInputs(Arrays.stream(sources).map(source -> new Input(this.sourcePathFromSourceText(Paths.get(Long.toString(System.nanoTime()), new String[0]), (String)source), null, () -> new ByteArrayInputStream(source.getBytes(StandardCharsets.UTF_8)), true)).collect(Collectors.toList()), null, ctx);
    }

    public Stream<SourceFile> parseInputs(Iterable<Input> var1, @Nullable Path var2, ExecutionContext var3);

    public boolean accept(Path var1);

    default public boolean accept(Input input) {
        return input.isSynthetic() || this.accept(input.getPath());
    }

    default public Stream<Input> acceptedInputs(Iterable<Input> input) {
        return StreamSupport.stream(input.spliterator(), false).filter(this::accept);
    }

    default public Parser reset() {
        return this;
    }

    default public Charset getCharset(ExecutionContext ctx) {
        Charset charset = new ParsingExecutionContextView(ctx).getCharset();
        return charset == null ? StandardCharsets.UTF_8 : charset;
    }

    public Path sourcePathFromSourceText(Path var1, String var2);

    public static class Input {
        private final boolean synthetic;
        private final Path path;
        private final Supplier<InputStream> source;
        @Nullable
        private final FileAttributes fileAttributes;

        public Input(Path path, Supplier<InputStream> source) {
            this(path, FileAttributes.fromPath(path), source, false);
        }

        public Input(Path path, @Nullable FileAttributes fileAttributes, Supplier<InputStream> source) {
            this(path, fileAttributes, source, false);
        }

        public Input(Path path, @Nullable FileAttributes fileAttributes, Supplier<InputStream> source, boolean synthetic) {
            this.path = path;
            this.fileAttributes = fileAttributes;
            this.source = source;
            this.synthetic = synthetic;
        }

        public static Input fromString(String source) {
            return Input.fromString(source, StandardCharsets.UTF_8);
        }

        public static Input fromString(Path sourcePath, String source) {
            return Input.fromString(sourcePath, source, StandardCharsets.UTF_8);
        }

        public static Input fromString(String source, Charset charset) {
            return Input.fromString(Paths.get(Long.toString(System.nanoTime()), new String[0]), source, charset);
        }

        public static Input fromString(Path sourcePath, String source, Charset charset) {
            return new Input(sourcePath, null, () -> new ByteArrayInputStream(source.getBytes(charset)), true);
        }

        public static Input fromResource(String resource) {
            return new Input(Paths.get(Long.toString(System.nanoTime()), new String[0]), null, () -> Input.class.getResourceAsStream(resource), true);
        }

        public static List<Input> fromResource(String resource, String delimiter) {
            return Input.fromResource(resource, delimiter, StandardCharsets.UTF_8);
        }

        public static List<Input> fromResource(String resource, String delimiter, @Nullable Charset charset) {
            Charset resourceCharset = charset == null ? StandardCharsets.UTF_8 : charset;
            return Arrays.stream(StringUtils.readFully(Objects.requireNonNull(Input.class.getResourceAsStream(resource)), resourceCharset).split(delimiter)).map(source -> new Input(Paths.get(Long.toString(System.nanoTime()), new String[0]), null, () -> new ByteArrayInputStream(source.getBytes(resourceCharset)), true)).collect(Collectors.toList());
        }

        public Path getPath() {
            return this.path;
        }

        public Path getRelativePath(@Nullable Path relativeTo) {
            return relativeTo == null ? this.path : relativeTo.relativize(this.path);
        }

        public EncodingDetectingInputStream getSource(ExecutionContext ctx) {
            return new EncodingDetectingInputStream(this.source.get(), ParsingExecutionContextView.view(ctx).getCharset());
        }

        public boolean isSynthetic() {
            return this.synthetic;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Input input = (Input)o;
            return Objects.equals(this.path, input.path);
        }

        public int hashCode() {
            return Objects.hash(this.path);
        }

        @Nullable
        public FileAttributes getFileAttributes() {
            return this.fileAttributes;
        }
    }

    public static abstract class Builder
    implements Cloneable {
        private final Class<? extends SourceFile> sourceFileType;

        public abstract Parser build();

        public abstract String getDslName();

        public Builder clone() {
            try {
                return (Builder)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public Builder(Class<? extends SourceFile> sourceFileType) {
            this.sourceFileType = sourceFileType;
        }

        public Class<? extends SourceFile> getSourceFileType() {
            return this.sourceFileType;
        }
    }
}

