/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Recipe;
import org.openrewrite.config.RecipeIntrospectionException;
import org.openrewrite.internal.ObjectMappers;
import org.openrewrite.internal.RecipeIntrospectionUtils;

public class RecipeLoader {
    private final @Nullable ClassLoader classLoader;
    private @Nullable ObjectMapper mapper;

    public RecipeLoader(@Nullable ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Recipe load(String recipeName, @Nullable Map<String, Object> recipeArgs) {
        try {
            Class<?> recipeClass = Class.forName(recipeName, true, this.classLoader == null ? this.getClass().getClassLoader() : this.classLoader);
            return RecipeIntrospectionUtils.constructRecipe(recipeClass, recipeArgs == null ? Collections.emptyMap() : recipeArgs);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | RecipeIntrospectionException e) {
            return this.instantiateRecipeUsingJackson(recipeName, recipeArgs == null ? Collections.emptyMap() : recipeArgs);
        }
    }

    public Recipe load(Class<?> recipeClass, @Nullable Map<String, Object> recipeArgs) {
        try {
            return RecipeIntrospectionUtils.constructRecipe(recipeClass, recipeArgs == null ? Collections.emptyMap() : recipeArgs);
        }
        catch (IllegalArgumentException | RecipeIntrospectionException e) {
            return this.instantiateRecipeUsingJackson(recipeClass.getName(), recipeArgs == null ? Collections.emptyMap() : recipeArgs);
        }
    }

    public ObjectMapper getMapper() {
        return this.mapper != null ? this.mapper : (this.mapper = ObjectMappers.propertyBasedMapper(this.classLoader));
    }

    private Recipe instantiateRecipeUsingJackson(String recipeName, Map<String, Object> args) throws IllegalArgumentException {
        HashMap<String, Object> withJsonType = new HashMap<String, Object>(args);
        withJsonType.put("@c", recipeName);
        return (Recipe)this.getMapper().convertValue(withJsonType, Recipe.class);
    }
}

