/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.rpc;

import java.util.function.Supplier;
import org.openrewrite.rpc.RewriteRpc;

public class RewriteRpcProcessManager<R extends RewriteRpc> {
    private final ThreadLocal<R> rpc = new ThreadLocal();
    private final ThreadLocal<Supplier<R>> factory = ThreadLocal.withInitial(() -> defaultFactory);

    public RewriteRpcProcessManager(Supplier<R> defaultFactory) {
    }

    public R getOrStart() {
        RewriteRpc current = (RewriteRpc)this.rpc.get();
        if (current == null) {
            current = (RewriteRpc)this.factory.get().get();
            this.rpc.set(current);
        }
        return (R)current;
    }

    public void setFactory(Supplier<R> factory) {
        this.factory.set(factory);
    }

    public void shutdown() {
        RewriteRpc current = (RewriteRpc)this.rpc.get();
        if (current != null) {
            current.shutdown();
            this.rpc.remove();
        }
    }
}

