/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marker;

import java.util.Objects;
import java.util.UUID;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.Marker;
import org.openrewrite.rpc.RpcCodec;
import org.openrewrite.rpc.RpcReceiveQueue;
import org.openrewrite.rpc.RpcSendQueue;

public final class SearchResult
implements Marker,
RpcCodec<SearchResult> {
    private final UUID id;
    private final @Nullable String description;

    @Contract(value="null -> null; !null -> !null")
    public static <T extends Tree> @Nullable T found(T t) {
        return SearchResult.found(t, null);
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static <T extends Tree> @Nullable T found(@Nullable T t, @Nullable String description) {
        if (t == null) {
            return null;
        }
        return t.withMarkers(t.getMarkers().add(new SearchResult(Tree.randomId(), description)));
    }

    @Incubating(since="8.0.0")
    public static <T extends Tree> T mergingFound(@Nullable T t, String description) {
        return SearchResult.mergingFound(t, description, ", ");
    }

    @Incubating(since="8.0.0")
    public static <T extends Tree> @Nullable T mergingFound(@Nullable T t, String description, String delimiter) {
        Objects.requireNonNull(delimiter, "delimiter must not be null");
        if (t == null) {
            return null;
        }
        return t.withMarkers(t.getMarkers().computeByType(new SearchResult(Tree.randomId(), description), (s1, s2) -> {
            if (s1 == null) {
                return s2;
            }
            if (s2 == null) {
                return s1;
            }
            if (s1.getDescription() == null) {
                return s2;
            }
            if (s2.getDescription() == null) {
                return s1;
            }
            if (s1.getDescription().equals(s2.getDescription()) || s1.getDescription().startsWith(s2.getDescription() + delimiter) || s1.getDescription().contains(delimiter + s2.getDescription() + delimiter) || s1.getDescription().endsWith(s2.getDescription())) {
                return s1;
            }
            return s1.withDescription(s1.getDescription() + delimiter + s2.getDescription());
        }));
    }

    @Override
    public String print(Cursor cursor, UnaryOperator<String> commentWrapper, boolean verbose) {
        return (String)commentWrapper.apply(this.description == null ? "" : "(" + this.description + ")");
    }

    @Override
    public void rpcSend(SearchResult after, RpcSendQueue q) {
        q.getAndSend(after, Marker::getId);
        q.getAndSend(after, SearchResult::getDescription);
    }

    @Override
    public SearchResult rpcReceive(SearchResult before, RpcReceiveQueue q) {
        return before.withId(q.receiveAndGet(before.getId(), UUID::fromString)).withDescription(q.receive(before.getDescription()));
    }

    @Generated
    public SearchResult(UUID id, @Nullable String description) {
        this.id = id;
        this.description = description;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchResult)) {
            return false;
        }
        SearchResult other = (SearchResult)o;
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    @Override
    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public @Nullable String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public SearchResult withId(UUID id) {
        return this.id == id ? this : new SearchResult(id, this.description);
    }

    @NonNull
    @Generated
    public SearchResult withDescription(@Nullable String description) {
        return this.description == description ? this : new SearchResult(this.id, description);
    }
}

