/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.rpc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jspecify.annotations.Nullable;
import org.objenesis.ObjenesisStd;
import org.openrewrite.marker.Markers;
import org.openrewrite.rpc.RpcObjectData;

public class RpcReceiveQueue {
    private final List<RpcObjectData> batch;
    private final Map<Integer, Object> refs;
    private final Supplier<List<RpcObjectData>> pull;

    public RpcReceiveQueue(Map<Integer, Object> refs, Supplier<List<RpcObjectData>> pull) {
        this.refs = refs;
        this.batch = new ArrayList<RpcObjectData>();
        this.pull = pull;
    }

    public RpcObjectData take() {
        if (this.batch.isEmpty()) {
            List<RpcObjectData> data = this.pull.get();
            this.batch.addAll(data);
        }
        return this.batch.remove(0);
    }

    public <T, U> U receiveAndGet(@Nullable T before, Function<T, U> apply) {
        return this.receive(before == null ? null : (T)apply.apply(before), null);
    }

    public Markers receiveMarkers(Markers markers) {
        return this.receive(markers, m -> m.withMarkers(this.receiveList(m.getMarkers(), null)));
    }

    public <T> T receive(@Nullable T before) {
        return this.receive(before, null);
    }

    public <T> T receive(@Nullable T before, @Nullable UnaryOperator<T> onChange) {
        RpcObjectData message = this.take();
        Integer ref = null;
        switch (message.getState()) {
            case NO_CHANGE: {
                return before;
            }
            case DELETE: {
                return null;
            }
            case ADD: {
                ref = message.getRef();
                if (this.refs.containsKey(ref)) {
                    return (T)this.refs.get(ref);
                }
                before = onChange == null || message.getValueType() == null ? message.getValue() : RpcReceiveQueue.newObj(message.getValueType());
            }
            case CHANGE: {
                Object after;
                Object object = after = onChange == null ? message.getValue() : onChange.apply(before);
                if (ref != null) {
                    this.refs.put(ref, after);
                }
                return (T)after;
            }
        }
        throw new UnsupportedOperationException("Unknown state type " + (Object)((Object)message.getState()));
    }

    public <T> List<T> receiveList(@Nullable List<T> before, @Nullable UnaryOperator<T> onChange) {
        RpcObjectData msg = this.take();
        switch (msg.getState()) {
            case NO_CHANGE: {
                return before;
            }
            case DELETE: {
                return null;
            }
            case ADD: {
                before = new ArrayList<T>();
            }
            case CHANGE: {
                msg = this.take();
                assert (msg.getState() == RpcObjectData.State.CHANGE);
                List positions = (List)msg.getValue();
                ArrayList<Object> after = new ArrayList<Object>(positions.size());
                Iterator iterator = positions.iterator();
                while (iterator.hasNext()) {
                    int beforeIdx = (Integer)iterator.next();
                    after.add(this.receive(beforeIdx >= 0 ? (T)Objects.requireNonNull(before).get(beforeIdx) : null, onChange));
                }
                return after;
            }
        }
        throw new UnsupportedOperationException((Object)((Object)msg.getState()) + " is not supported for lists.");
    }

    private static <T> T newObj(String type) {
        try {
            Class<?> clazz = Class.forName(type);
            return (T)new ObjenesisStd().newInstance(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

