/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Incubating;

@Incubating(since="8.38.0")
public class AdaptiveRadixTree<V> {
    private final KeyTable keyTable;
    private @Nullable Node<V> root;

    public AdaptiveRadixTree() {
        this.keyTable = new KeyTable();
    }

    private AdaptiveRadixTree(KeyTable keyTable) {
        this.keyTable = keyTable;
    }

    public void insert(String key, V value) {
        this.insert(key.getBytes(StandardCharsets.UTF_8), value);
    }

    public void insert(byte[] keyBytes, V value) {
        this.root = this.root == null ? LeafNode.create(keyBytes, 0, keyBytes.length, value, this.keyTable) : this.root.insert(keyBytes, 0, value, this.keyTable);
    }

    public @Nullable V search(String key) {
        if (this.root == null) {
            return null;
        }
        return this.search(key.getBytes(StandardCharsets.UTF_8));
    }

    public @Nullable V search(byte[] bytes) {
        if (this.root == null) {
            return null;
        }
        return this.root.search(bytes, 0, this.keyTable);
    }

    public AdaptiveRadixTree<V> copy() {
        AdaptiveRadixTree<V> newTree = new AdaptiveRadixTree<V>(this.keyTable.copy());
        if (this.root != null) {
            newTree.root = this.root.copy();
        }
        return newTree;
    }

    public void clear() {
        this.root = null;
        this.keyTable.clear();
    }

    private static class KeyTable {
        private static final int INITIAL_CAPACITY = 131072;
        private static final int MAX_SMALL_GROWTH_SIZE = 0x100000;
        private static final double LARGE_GROWTH_FACTOR = 1.3;
        private byte[] storage = new byte[131072];
        private int size = 0;

        KeyTable() {
        }

        KeyTable copy() {
            KeyTable copy = new KeyTable();
            copy.storage = Arrays.copyOf(this.storage, this.storage.length);
            copy.size = this.size;
            return copy;
        }

        int store(byte[] key, int offset, int length) {
            this.ensureCapacity(length);
            int startOffset = this.size;
            System.arraycopy(key, offset, this.storage, this.size, length);
            this.size += length;
            return startOffset;
        }

        boolean matches(byte[] key, int keyOffset, int storedOffset, int length) {
            if (length <= 0) {
                return true;
            }
            if (keyOffset + length > key.length) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                if (key[keyOffset + i] == this.storage[storedOffset + i]) continue;
                return false;
            }
            return true;
        }

        private void ensureCapacity(int additional) {
            int required = this.size + additional;
            if (required <= this.storage.length) {
                return;
            }
            int newCapacity = this.storage.length < 0x100000 ? Math.max(this.storage.length * 2, required) : Math.max((int)((double)this.storage.length * 1.3), required);
            this.storage = Arrays.copyOf(this.storage, newCapacity);
        }

        public byte get(int offset) {
            return this.storage[offset];
        }

        public void clear() {
            this.storage = new byte[131072];
            this.size = 0;
        }
    }

    private static abstract class Node<V> {
        protected int keyOffset;
        protected int keyLength;

        protected Node(int keyOffset, int keyLength) {
            this.keyOffset = keyOffset;
            this.keyLength = keyLength;
        }

        abstract @Nullable V search(byte[] var1, int var2, KeyTable var3);

        abstract Node<V> insert(byte[] var1, int var2, V var3, KeyTable var4);

        abstract Node<V> copy();

        protected boolean matchesPartialKey(byte[] key, int depth, KeyTable keyTable) {
            return keyTable.matches(key, depth, this.keyOffset, this.keyLength);
        }
    }

    private static class LeafNode<V>
    extends Node<V> {
        private final V value;

        LeafNode(int keyOffset, int keyLength, V value) {
            super(keyOffset, keyLength);
            this.value = value;
        }

        static <V> LeafNode<V> create(byte[] key, int offset, int length, V value, KeyTable keyTable) {
            if (length <= 0) {
                return new LeafNode<V>(-1, 0, value);
            }
            int keyOffset = keyTable.store(key, offset, length);
            return new LeafNode<V>(keyOffset, length, value);
        }

        @Override
        @Nullable V search(byte[] key, int depth, KeyTable keyTable) {
            switch (this.keyLength) {
                case 0: {
                    return depth == key.length ? (V)this.value : null;
                }
                case 1: {
                    return depth < key.length && key[depth] == keyTable.get(this.keyOffset) && depth + 1 == key.length ? (V)this.value : null;
                }
            }
            if (!this.matchesPartialKey(key, depth, keyTable)) {
                return null;
            }
            return depth + this.keyLength == key.length ? (V)this.value : null;
        }

        @Override
        Node<V> insert(byte[] key, int depth, V value, KeyTable keyTable) {
            int commonPrefix;
            if (this.keyLength == 0) {
                if (depth == key.length) {
                    return new LeafNode<V>(-1, 0, value);
                }
                Node4<V> newNode = new Node4<V>(-1, 0);
                newNode.value = this.value;
                LeafNode<V> newChild = LeafNode.create(key, depth + 1, key.length - (depth + 1), value, keyTable);
                newNode.addChild(key[depth], newChild, keyTable);
                return newNode;
            }
            if (depth + this.keyLength == key.length && keyTable.matches(key, depth, this.keyOffset, this.keyLength)) {
                return new LeafNode<V>(this.keyOffset, this.keyLength, value);
            }
            int maxLength = Math.min(key.length - depth, this.keyLength);
            for (commonPrefix = 0; commonPrefix < maxLength && key[depth + commonPrefix] == keyTable.get(this.keyOffset + commonPrefix); ++commonPrefix) {
            }
            Node4<V> newNode = new Node4<V>(this.keyOffset, commonPrefix);
            int remainingOldLength = this.keyLength - commonPrefix;
            if (remainingOldLength > 0) {
                byte firstByte = keyTable.get(this.keyOffset + commonPrefix);
                LeafNode<V> oldChild = new LeafNode<V>(this.keyOffset + commonPrefix + 1, remainingOldLength - 1, this.value);
                newNode.addChild(firstByte, oldChild, keyTable);
            } else {
                newNode.value = this.value;
            }
            int remainingNewLength = key.length - (depth + commonPrefix);
            if (remainingNewLength > 0) {
                byte firstByte = key[depth + commonPrefix];
                LeafNode<V> newChild = LeafNode.create(key, depth + commonPrefix + 1, remainingNewLength - 1, value, keyTable);
                newNode.addChild(firstByte, newChild, keyTable);
            } else {
                newNode.value = value;
            }
            return newNode;
        }

        @Override
        Node<V> copy() {
            return new LeafNode<V>(this.keyOffset, this.keyLength, this.value);
        }
    }

    private static class Node256<V>
    extends InternalNode<V> {
        private final @Nullable Node<V>[] children = new Node[256];

        Node256(int keyOffset, int keyLength) {
            super(keyOffset, keyLength);
        }

        @Override
        @Nullable Node<V> getChild(byte key) {
            return this.children[key & 0xFF];
        }

        @Override
        @Nullable InternalNode<V> addChild(byte key, Node<V> child, KeyTable keyTable) {
            int idx = key & 0xFF;
            this.children[idx] = child;
            return null;
        }

        @Override
        Node<V> copy() {
            Node256<V> clone = new Node256<V>(this.keyOffset, this.keyLength);
            clone.value = this.value;
            System.arraycopy(this.children, 0, clone.children, 0, this.children.length);
            for (int i = 0; i < 256; ++i) {
                Node<V> child = this.children[i];
                if (child == null) continue;
                clone.children[i] = child.copy();
            }
            return clone;
        }
    }

    private static class Node64<V>
    extends InternalNode<V> {
        private long bitmap0 = 0L;
        private long bitmap1 = 0L;
        private long bitmap2 = 0L;
        private long bitmap3 = 0L;
        private @Nullable Node<V>[] children = new Node[0];

        Node64(int keyOffset, int keyLength) {
            super(keyOffset, keyLength);
        }

        @Override
        @Nullable Node<V> getChild(byte key) {
            long bitmap;
            int idx = key & 0xFF;
            int longIndex = idx >>> 6;
            int bitIndex = idx & 0x3F;
            long mask = 1L << bitIndex;
            switch (longIndex) {
                case 0: {
                    bitmap = this.bitmap0;
                    break;
                }
                case 1: {
                    bitmap = this.bitmap1;
                    break;
                }
                case 2: {
                    bitmap = this.bitmap2;
                    break;
                }
                case 3: {
                    bitmap = this.bitmap3;
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid index");
                }
            }
            if ((bitmap & mask) == 0L) {
                return null;
            }
            int pos = 0;
            if (longIndex > 0) {
                pos += Long.bitCount(this.bitmap0);
            }
            if (longIndex > 1) {
                pos += Long.bitCount(this.bitmap1);
            }
            if (longIndex > 2) {
                pos += Long.bitCount(this.bitmap2);
            }
            return this.children[pos += Long.bitCount(bitmap & mask - 1L)];
        }

        @Override
        @Nullable InternalNode<V> addChild(byte key, Node<V> child, KeyTable keyTable) {
            boolean exists;
            int idx = key & 0xFF;
            int longIndex = idx >>> 6;
            int bitIndex = idx & 0x3F;
            long mask = 1L << bitIndex;
            switch (longIndex) {
                case 0: {
                    exists = (this.bitmap0 & mask) != 0L;
                    break;
                }
                case 1: {
                    exists = (this.bitmap1 & mask) != 0L;
                    break;
                }
                case 2: {
                    exists = (this.bitmap2 & mask) != 0L;
                    break;
                }
                case 3: {
                    exists = (this.bitmap3 & mask) != 0L;
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid index");
                }
            }
            if (exists) {
                int pos = 0;
                if (longIndex > 0) {
                    pos += Long.bitCount(this.bitmap0);
                }
                if (longIndex > 1) {
                    pos += Long.bitCount(this.bitmap1);
                }
                if (longIndex > 2) {
                    pos += Long.bitCount(this.bitmap2);
                }
                switch (longIndex) {
                    case 0: {
                        pos += Long.bitCount(this.bitmap0 & mask - 1L);
                        break;
                    }
                    case 1: {
                        pos += Long.bitCount(this.bitmap1 & mask - 1L);
                        break;
                    }
                    case 2: {
                        pos += Long.bitCount(this.bitmap2 & mask - 1L);
                        break;
                    }
                    case 3: {
                        pos += Long.bitCount(this.bitmap3 & mask - 1L);
                    }
                }
                this.children[pos] = child;
                return null;
            }
            if (this.children.length >= 64) {
                Node256<V> node256 = new Node256<V>(-1, 0);
                node256.value = this.value;
                for (int i = 0; i < 256; ++i) {
                    byte childKey = (byte)i;
                    Node<V> existingChild = this.getChild(childKey);
                    if (existingChild == null) continue;
                    node256.addChild(childKey, existingChild, keyTable);
                }
                node256.addChild(key, child, keyTable);
                return node256;
            }
            int pos = 0;
            if (longIndex > 0) {
                pos += Long.bitCount(this.bitmap0);
            }
            if (longIndex > 1) {
                pos += Long.bitCount(this.bitmap1);
            }
            if (longIndex > 2) {
                pos += Long.bitCount(this.bitmap2);
            }
            switch (longIndex) {
                case 0: {
                    pos += Long.bitCount(this.bitmap0 & mask - 1L);
                    break;
                }
                case 1: {
                    pos += Long.bitCount(this.bitmap1 & mask - 1L);
                    break;
                }
                case 2: {
                    pos += Long.bitCount(this.bitmap2 & mask - 1L);
                    break;
                }
                case 3: {
                    pos += Long.bitCount(this.bitmap3 & mask - 1L);
                }
            }
            Node[] newChildren = new Node[this.children.length + 1];
            System.arraycopy(this.children, 0, newChildren, 0, pos);
            newChildren[pos] = child;
            System.arraycopy(this.children, pos, newChildren, pos + 1, this.children.length - pos);
            this.children = newChildren;
            switch (longIndex) {
                case 0: {
                    this.bitmap0 |= mask;
                    break;
                }
                case 1: {
                    this.bitmap1 |= mask;
                    break;
                }
                case 2: {
                    this.bitmap2 |= mask;
                    break;
                }
                case 3: {
                    this.bitmap3 |= mask;
                }
            }
            return null;
        }

        @Override
        Node<V> copy() {
            Node64<V> clone = new Node64<V>(this.keyOffset, this.keyLength);
            clone.value = this.value;
            clone.bitmap0 = this.bitmap0;
            clone.bitmap1 = this.bitmap1;
            clone.bitmap2 = this.bitmap2;
            clone.bitmap3 = this.bitmap3;
            clone.children = new Node[this.children.length];
            for (int i = 0; i < this.children.length; ++i) {
                clone.children[i] = this.children[i].copy();
            }
            return clone;
        }
    }

    private static class Node16<V>
    extends InternalNode<V> {
        private static final int LINEAR_SEARCH_THRESHOLD = 12;
        private byte[] keys = new byte[16];
        private @Nullable Node<V>[] children = new Node[16];
        private int size = 0;

        Node16(int keyOffset, int keyLength) {
            super(keyOffset, keyLength);
        }

        @Override
        @Nullable Node<V> getChild(byte key) {
            if (this.size <= 12) {
                for (int i = 0; i < this.size; ++i) {
                    if (this.keys[i] != key) continue;
                    return this.children[i];
                }
                return null;
            }
            int idx = this.unsignedBinarySearch(this.keys, this.size, key & 0xFF);
            return idx >= 0 ? this.children[idx] : null;
        }

        private int unsignedBinarySearch(byte[] array, int toIndex, int key) {
            int low = 0;
            int high = toIndex - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                int midVal = array[mid] & 0xFF;
                if (midVal < key) {
                    low = mid + 1;
                    continue;
                }
                if (midVal > key) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(low + 1);
        }

        @Override
        @Nullable InternalNode<V> addChild(byte key, Node<V> child, KeyTable keyTable) {
            int pos;
            for (int i = 0; i < this.size; ++i) {
                if (this.keys[i] != key) continue;
                this.children[i] = child;
                return null;
            }
            if (this.size >= 16) {
                Node64<V> node = new Node64<V>(this.keyOffset, this.keyLength);
                node.value = this.value;
                for (int i = 0; i < this.size; ++i) {
                    node.addChild(this.keys[i], this.children[i], keyTable);
                }
                node.addChild(key, child, keyTable);
                return node;
            }
            for (pos = 0; pos < this.size && (this.keys[pos] & 0xFF) < (key & 0xFF); ++pos) {
            }
            if (pos < this.size) {
                System.arraycopy(this.keys, pos, this.keys, pos + 1, this.size - pos);
                System.arraycopy(this.children, pos, this.children, pos + 1, this.size - pos);
            }
            this.keys[pos] = key;
            this.children[pos] = child;
            ++this.size;
            return null;
        }

        @Override
        Node<V> copy() {
            Node16<V> clone = new Node16<V>(this.keyOffset, this.keyLength);
            clone.value = this.value;
            clone.size = this.size;
            clone.keys = Arrays.copyOf(this.keys, this.keys.length);
            clone.children = Arrays.copyOf(this.children, this.children.length);
            for (int i = 0; i < this.size; ++i) {
                clone.children[i] = this.children[i].copy();
            }
            return clone;
        }
    }

    private static class Node4<V>
    extends InternalNode<V> {
        private byte k0;
        private byte k1;
        private byte k2;
        private byte k3;
        private @Nullable Node<V> c0;
        private @Nullable Node<V> c1;
        private @Nullable Node<V> c2;
        private @Nullable Node<V> c3;
        private byte size = 0;

        Node4(int keyOffset, int keyLength) {
            super(keyOffset, keyLength);
        }

        @Override
        @Nullable Node<V> getChild(byte key) {
            int mask = (1 << this.size) - 1;
            return (mask & 1) != 0 && this.k0 == key ? this.c0 : ((mask & 2) != 0 && this.k1 == key ? this.c1 : ((mask & 4) != 0 && this.k2 == key ? this.c2 : ((mask & 8) != 0 && this.k3 == key ? this.c3 : null)));
        }

        @Override
        @Nullable InternalNode<V> addChild(byte key, Node<V> child, KeyTable keyTable) {
            if (this.size > 0) {
                if (this.k0 == key) {
                    this.c0 = child;
                    return null;
                }
                if (this.size > 1) {
                    if (this.k1 == key) {
                        this.c1 = child;
                        return null;
                    }
                    if (this.size > 2 && this.k2 == key) {
                        this.c2 = child;
                        return null;
                    }
                    if (this.size > 3 && this.k3 == key) {
                        this.c3 = child;
                        return null;
                    }
                }
            }
            if (this.size == 4) {
                Node16<V> node = new Node16<V>(this.keyOffset, this.keyLength);
                node.value = this.value;
                node.addChild(this.k0, this.c0, keyTable);
                node.addChild(this.k1, this.c1, keyTable);
                node.addChild(this.k2, this.c2, keyTable);
                node.addChild(this.k3, this.c3, keyTable);
                node.addChild(key, child, keyTable);
                return node;
            }
            byte keyByte = (byte)(key & 0xFF);
            if (this.size == 0) {
                this.k0 = keyByte;
                this.c0 = child;
            } else if (this.size == 1) {
                if (keyByte < (this.k0 & 0xFF)) {
                    this.k1 = this.k0;
                    this.c1 = this.c0;
                    this.k0 = keyByte;
                    this.c0 = child;
                } else {
                    this.k1 = keyByte;
                    this.c1 = child;
                }
            } else if (this.size == 2) {
                if (keyByte < (this.k0 & 0xFF)) {
                    this.k2 = this.k1;
                    this.c2 = this.c1;
                    this.k1 = this.k0;
                    this.c1 = this.c0;
                    this.k0 = keyByte;
                    this.c0 = child;
                } else if (keyByte < (this.k1 & 0xFF)) {
                    this.k2 = this.k1;
                    this.c2 = this.c1;
                    this.k1 = keyByte;
                    this.c1 = child;
                } else {
                    this.k2 = keyByte;
                    this.c2 = child;
                }
            } else if (keyByte < (this.k0 & 0xFF)) {
                this.k3 = this.k2;
                this.c3 = this.c2;
                this.k2 = this.k1;
                this.c2 = this.c1;
                this.k1 = this.k0;
                this.c1 = this.c0;
                this.k0 = keyByte;
                this.c0 = child;
            } else if (keyByte < (this.k1 & 0xFF)) {
                this.k3 = this.k2;
                this.c3 = this.c2;
                this.k2 = this.k1;
                this.c2 = this.c1;
                this.k1 = keyByte;
                this.c1 = child;
            } else if (keyByte < (this.k2 & 0xFF)) {
                this.k3 = this.k2;
                this.c3 = this.c2;
                this.k2 = keyByte;
                this.c2 = child;
            } else {
                this.k3 = keyByte;
                this.c3 = child;
            }
            this.size = (byte)(this.size + 1);
            return null;
        }

        @Override
        Node<V> copy() {
            Node4<V> clone = new Node4<V>(this.keyOffset, this.keyLength);
            clone.value = this.value;
            clone.size = this.size;
            clone.k0 = this.k0;
            clone.k1 = this.k1;
            clone.k2 = this.k2;
            clone.k3 = this.k3;
            if (this.size > 0) {
                clone.c0 = this.c0.copy();
            }
            if (this.size > 1) {
                clone.c1 = this.c1.copy();
            }
            if (this.size > 2) {
                clone.c2 = this.c2.copy();
            }
            if (this.size > 3) {
                clone.c3 = this.c3.copy();
            }
            return clone;
        }
    }

    private static abstract class InternalNode<V>
    extends Node<V> {
        protected @Nullable V value;

        protected InternalNode(int keyOffset, int keyLength) {
            super(keyOffset, keyLength);
        }

        abstract @Nullable Node<V> getChild(byte var1);

        abstract @Nullable InternalNode<V> addChild(byte var1, Node<V> var2, KeyTable var3);

        void adjustKey(int newKeyOffset, int newKeyLength) {
            this.keyOffset = newKeyOffset;
            this.keyLength = newKeyLength;
        }

        @Override
        @Nullable V search(byte[] key, int depth, KeyTable keyTable) {
            if (this.keyLength == 0) {
                if (depth == key.length) {
                    return this.value;
                }
                Node<V> child = this.getChild(key[depth]);
                return child != null ? (V)child.search(key, depth + 1, keyTable) : null;
            }
            if (!this.matchesPartialKey(key, depth, keyTable)) {
                return null;
            }
            if ((depth += this.keyLength) == key.length) {
                return this.value;
            }
            Node<V> child = this.getChild(key[depth]);
            return child != null ? (V)child.search(key, depth + 1, keyTable) : null;
        }

        @Override
        Node<V> insert(byte[] key, int depth, V value, KeyTable keyTable) {
            if (!this.matchesPartialKey(key, depth, keyTable)) {
                int commonPrefix;
                int maxLength = Math.min(key.length - depth, this.keyLength);
                for (commonPrefix = 0; commonPrefix < maxLength && key[depth + commonPrefix] == keyTable.get(this.keyOffset + commonPrefix); ++commonPrefix) {
                }
                Node4<V> newNode = this.split(commonPrefix, keyTable);
                int remainingNewLength = key.length - (depth + commonPrefix);
                if (remainingNewLength > 0) {
                    byte firstByte = key[depth + commonPrefix];
                    LeafNode<V> leafNode = LeafNode.create(key, depth + commonPrefix + 1, remainingNewLength - 1, value, keyTable);
                    InternalNode<V> grown = newNode.addChild(firstByte, leafNode, keyTable);
                    return grown != null ? grown : newNode;
                }
                newNode.value = value;
                return newNode;
            }
            if ((depth += this.keyLength) == key.length) {
                this.value = value;
                return this;
            }
            byte nextByte = key[depth];
            Node<V> child = this.getChild(nextByte);
            if (child == null) {
                LeafNode<V> newChild = LeafNode.create(key, depth + 1, key.length - (depth + 1), value, keyTable);
                InternalNode grown = this.addChild(nextByte, newChild, keyTable);
                return grown != null ? grown : this;
            }
            Node<V> newChild = child.insert(key, depth + 1, value, keyTable);
            if (newChild != child) {
                InternalNode grown = this.addChild(nextByte, newChild, keyTable);
                return grown != null ? grown : this;
            }
            return this;
        }

        private Node4<V> split(int commonPrefix, KeyTable keyTable) {
            Node4 newParent = new Node4(this.keyOffset, commonPrefix);
            Object object = newParent.value = commonPrefix == this.keyLength ? (Object)this.value : null;
            assert (commonPrefix < this.keyLength);
            byte splitByte = keyTable.get(this.keyOffset + commonPrefix);
            this.adjustKey(this.keyOffset + commonPrefix + 1, this.keyLength - commonPrefix - 1);
            newParent.addChild(splitByte, this, keyTable);
            return newParent;
        }
    }
}

