/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.text;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.marker.Markers;
import org.openrewrite.text.PlainText;
import org.openrewrite.tree.ParseError;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;

public class PlainTextParser
implements Parser {
    public static PlainText convert(SourceFile sourceFile) {
        if (sourceFile instanceof PlainText) {
            return (PlainText)sourceFile;
        }
        PlainText text = (PlainText)PlainTextParser.builder().build().parse(sourceFile.printAll()).findFirst().orElseThrow(() -> new IllegalStateException("Failed to parse as plain text")).withSourcePath(sourceFile.getSourcePath()).withFileAttributes(sourceFile.getFileAttributes()).withCharsetBomMarked(sourceFile.isCharsetBomMarked()).withId(sourceFile.getId());
        if (sourceFile.getCharset() != null) {
            text = (PlainText)text.withCharset(sourceFile.getCharset());
        }
        return text;
    }

    @Override
    public Stream<SourceFile> parseInputs(Iterable<Parser.Input> sources, @Nullable Path relativeTo, ExecutionContext ctx) {
        ParsingEventListener parsingListener = ParsingExecutionContextView.view(ctx).getParsingListener();
        return StreamSupport.stream(sources.spliterator(), false).map(input -> {
            Path path = input.getRelativePath(relativeTo);
            parsingListener.startedParsing((Parser.Input)input);
            try {
                EncodingDetectingInputStream is = input.getSource(ctx);
                String sourceStr = is.readFully();
                PlainText plainText = new PlainText(Tree.randomId(), path, Markers.EMPTY, is.getCharset().name(), is.isCharsetBomMarked(), input.getFileAttributes(), null, sourceStr, null, null);
                parsingListener.parsed((Parser.Input)input, plainText);
                return plainText;
            }
            catch (Throwable t) {
                ctx.getOnError().accept(t);
                return ParseError.build(this, input, relativeTo, ctx, t);
            }
        });
    }

    @Override
    public boolean accept(Path path) {
        return true;
    }

    @Override
    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("file.txt");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Parser.Builder {
        private @Nullable Collection<PathMatcher> plainTextMasks;

        public Builder() {
            super(PlainText.class);
        }

        public Builder plainTextMasks(Collection<PathMatcher> plainTextMasks) {
            this.plainTextMasks = plainTextMasks;
            return this;
        }

        public Builder plainTextMasks(Path basePath, Iterable<String> plainTextMaskGlobs) {
            return this.plainTextMasks(StreamSupport.stream(plainTextMaskGlobs.spliterator(), false).map(o -> basePath.getFileSystem().getPathMatcher("glob:" + o)).collect(Collectors.toList()));
        }

        @Override
        public PlainTextParser build() {
            if (this.plainTextMasks != null) {
                return new PlainTextParser(){

                    @Override
                    public boolean accept(Path path) {
                        for (PathMatcher matcher : plainTextMasks) {
                            if (!matcher.matches(path)) continue;
                            return true;
                        }
                        if (!path.isAbsolute() && !path.startsWith(File.separator)) {
                            return this.accept(Paths.get("/" + path, new String[0]));
                        }
                        return false;
                    }
                };
            }
            return new PlainTextParser();
        }

        @Override
        public String getDslName() {
            return "text";
        }
    }
}

