/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Incubating;

@Incubating(since="8.38.0")
public class AdaptiveRadixTree<V> {
    private transient int size = 0;
    private @Nullable Node<V> root;

    public void insert(String key, V value) {
        this.insert(key.getBytes(StandardCharsets.UTF_8), value);
    }

    public void insert(byte[] keyBytes, V value) {
        this.root = this.root == null ? new LeafNode<V>(keyBytes, value) : this.root.insert(keyBytes, 0, value);
    }

    public @Nullable V search(String key) {
        if (this.root == null) {
            return null;
        }
        return this.search(key.getBytes(StandardCharsets.UTF_8));
    }

    public @Nullable V search(byte[] bytes) {
        if (this.root == null) {
            return null;
        }
        return this.root.search(bytes, 0);
    }

    public AdaptiveRadixTree<V> copy() {
        AdaptiveRadixTree<V> newTree = new AdaptiveRadixTree<V>();
        if (this.root != null) {
            newTree.root = this.root.copy();
        }
        return newTree;
    }

    public void clear() {
        this.root = null;
    }

    private static abstract class Node<V> {
        protected byte[] partialKey;

        protected Node(byte[] partialKey) {
            this.partialKey = partialKey;
        }

        abstract @Nullable V search(byte[] var1, int var2);

        abstract Node<V> insert(byte[] var1, int var2, V var3);

        abstract Node<V> copy();

        protected boolean matchesPartialKey(byte[] key, int depth) {
            int len = this.partialKey.length;
            if (depth + len > key.length) {
                return false;
            }
            switch (len) {
                case 0: {
                    return true;
                }
                case 1: {
                    return key[depth] == this.partialKey[0];
                }
                case 2: {
                    return key[depth] == this.partialKey[0] && key[depth + 1] == this.partialKey[1];
                }
            }
            for (int i = 0; i < len; ++i) {
                if (key[depth + i] == this.partialKey[i]) continue;
                return false;
            }
            return true;
        }

        protected static int findCommonPrefixLength(byte[] key1, int start1, byte[] key2) {
            int i;
            int maxLength = Math.min(key1.length - start1, key2.length);
            for (i = 0; i < maxLength && key1[start1 + i] == key2[i]; ++i) {
            }
            return i;
        }
    }

    private static class LeafNode<V>
    extends Node<V> {
        private static final byte[] EMPTY_BYTES = new byte[0];
        private final V value;

        LeafNode(byte[] partialKey, V value) {
            super(partialKey);
            this.value = value;
        }

        @Override
        @Nullable V search(byte[] key, int depth) {
            switch (this.partialKey.length) {
                case 0: {
                    return depth == key.length ? (V)this.value : null;
                }
                case 1: {
                    return depth < key.length && key[depth] == this.partialKey[0] && depth + 1 == key.length ? (V)this.value : null;
                }
            }
            if (!this.matchesPartialKey(key, depth)) {
                return null;
            }
            return depth + this.partialKey.length == key.length ? (V)this.value : null;
        }

        @Override
        Node<V> insert(byte[] key, int depth, V value) {
            if (this.partialKey.length == 0) {
                if (depth == key.length) {
                    return new LeafNode<V>(this.partialKey, value);
                }
                Node4<V> newNode = new Node4<V>(this.partialKey);
                newNode.value = this.value;
                int remainingLength = key.length - (depth + 1);
                byte[] remainingKey = remainingLength == 0 ? EMPTY_BYTES : Arrays.copyOfRange(key, depth + 1, key.length);
                newNode.addChild(key[depth], new LeafNode<V>(remainingKey, value));
                return newNode;
            }
            if (this.matchesPartialKey(key, depth) && depth + this.partialKey.length == key.length) {
                return new LeafNode<V>(this.partialKey, value);
            }
            int commonPrefix = LeafNode.findCommonPrefixLength(key, depth, this.partialKey);
            byte[] commonKey = Arrays.copyOfRange(key, depth, depth + commonPrefix);
            Node4<V> newNode = new Node4<V>(commonKey);
            int remainingOldLength = this.partialKey.length - commonPrefix;
            if (remainingOldLength > 0) {
                byte firstByte = this.partialKey[commonPrefix];
                newNode.addChild(firstByte, new LeafNode<V>(Arrays.copyOfRange(this.partialKey, commonPrefix + 1, this.partialKey.length), this.value));
            } else {
                newNode.value = this.value;
            }
            int remainingNewLength = key.length - (depth + commonPrefix);
            if (remainingNewLength > 0) {
                byte firstByte = key[depth + commonPrefix];
                newNode.addChild(firstByte, new LeafNode<V>(Arrays.copyOfRange(key, depth + commonPrefix + 1, key.length), value));
            } else {
                newNode.value = value;
            }
            return newNode;
        }

        @Override
        Node<V> copy() {
            return new LeafNode<V>(Arrays.copyOf(this.partialKey, this.partialKey.length), this.value);
        }
    }

    private static class Node256<V>
    extends InternalNode<V> {
        private final @Nullable Node<V>[] children = new Node[256];

        Node256(byte[] partialKey) {
            super(partialKey);
        }

        @Override
        @Nullable Node<V> getChild(byte key) {
            return this.children[key & 0xFF];
        }

        @Override
        @Nullable InternalNode<V> addChild(byte key, Node<V> child) {
            int idx = key & 0xFF;
            this.children[idx] = child;
            return null;
        }

        @Override
        InternalNode<V> cloneWithNewKey(byte[] newKey) {
            Node256<V> clone = new Node256<V>(newKey);
            clone.value = this.value;
            System.arraycopy(this.children, 0, clone.children, 0, this.children.length);
            return clone;
        }

        @Override
        Node<V> copy() {
            Node256<V> clone = new Node256<V>(Arrays.copyOf(this.partialKey, this.partialKey.length));
            clone.value = this.value;
            System.arraycopy(this.children, 0, clone.children, 0, this.children.length);
            for (int i = 0; i < 256; ++i) {
                Node<V> child = this.children[i];
                if (child == null) continue;
                clone.children[i] = child.copy();
            }
            return clone;
        }
    }

    private static class Node48<V>
    extends InternalNode<V> {
        private byte[] index = new byte[256];
        private @Nullable Node<V>[] children;
        private int size;

        Node48(byte[] partialKey) {
            super(partialKey);
            Arrays.fill(this.index, (byte)-1);
            this.children = new Node[48];
            this.size = 0;
        }

        @Override
        @Nullable Node<V> getChild(byte key) {
            int idx = this.index[key] & 0xFF;
            return idx < this.size ? this.children[idx] : null;
        }

        @Override
        @Nullable InternalNode<V> addChild(byte key, Node<V> child) {
            int idx = key & 0xFF;
            if (this.index[idx] >= 0) {
                this.children[this.index[idx]] = child;
                return null;
            }
            if (this.size >= 48) {
                Node256<V> node = new Node256<V>(this.partialKey);
                node.value = this.value;
                for (int i = 0; i < 256; ++i) {
                    if (this.index[i] < 0) continue;
                    node.addChild((byte)i, this.children[this.index[i]]);
                }
                node.addChild(key, child);
                return node;
            }
            this.index[idx] = (byte)this.size;
            this.children[this.size] = child;
            ++this.size;
            return null;
        }

        @Override
        InternalNode<V> cloneWithNewKey(byte[] newKey) {
            Node48<V> clone = new Node48<V>(newKey);
            clone.value = this.value;
            System.arraycopy(this.index, 0, clone.index, 0, this.index.length);
            System.arraycopy(this.children, 0, clone.children, 0, this.size);
            clone.size = this.size;
            return clone;
        }

        @Override
        Node<V> copy() {
            Node48<V> clone = new Node48<V>(Arrays.copyOf(this.partialKey, this.partialKey.length));
            clone.value = this.value;
            clone.size = this.size;
            clone.index = Arrays.copyOf(this.index, this.index.length);
            clone.children = Arrays.copyOf(this.children, this.children.length);
            for (int i = 0; i < this.size; ++i) {
                clone.children[i] = this.children[i].copy();
            }
            return clone;
        }
    }

    private static class Node16<V>
    extends InternalNode<V> {
        private static final int LINEAR_SEARCH_THRESHOLD = 8;
        private byte[] keys = new byte[16];
        private @Nullable Node<V>[] children = new Node[16];
        private int size = 0;

        Node16(byte[] partialKey) {
            super(partialKey);
        }

        @Override
        @Nullable Node<V> getChild(byte key) {
            if (this.size <= 8) {
                for (int i = 0; i < this.size; ++i) {
                    if (this.keys[i] != key) continue;
                    return this.children[i];
                }
                return null;
            }
            int idx = this.unsignedBinarySearch(this.keys, this.size, key & 0xFF);
            return idx >= 0 ? this.children[idx] : null;
        }

        private int unsignedBinarySearch(byte[] array, int toIndex, int key) {
            int low = 0;
            int high = toIndex - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                int midVal = array[mid] & 0xFF;
                if (midVal < key) {
                    low = mid + 1;
                    continue;
                }
                if (midVal > key) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(low + 1);
        }

        @Override
        @Nullable InternalNode<V> addChild(byte key, Node<V> child) {
            int pos;
            for (int i = 0; i < this.size; ++i) {
                if (this.keys[i] != key) continue;
                this.children[i] = child;
                return null;
            }
            if (this.size >= 16) {
                Node48<V> node = new Node48<V>(this.partialKey);
                node.value = this.value;
                for (int i = 0; i < this.size; ++i) {
                    node.addChild(this.keys[i], this.children[i]);
                }
                node.addChild(key, child);
                return node;
            }
            for (pos = 0; pos < this.size && (this.keys[pos] & 0xFF) < (key & 0xFF); ++pos) {
            }
            if (pos < this.size) {
                System.arraycopy(this.keys, pos, this.keys, pos + 1, this.size - pos);
                System.arraycopy(this.children, pos, this.children, pos + 1, this.size - pos);
            }
            this.keys[pos] = key;
            this.children[pos] = child;
            ++this.size;
            return null;
        }

        @Override
        InternalNode<V> cloneWithNewKey(byte[] newKey) {
            Node16<V> clone = new Node16<V>(newKey);
            clone.value = this.value;
            System.arraycopy(this.keys, 0, clone.keys, 0, this.size);
            System.arraycopy(this.children, 0, clone.children, 0, this.size);
            clone.size = this.size;
            return clone;
        }

        @Override
        Node<V> copy() {
            Node16<V> clone = new Node16<V>(Arrays.copyOf(this.partialKey, this.partialKey.length));
            clone.value = this.value;
            clone.size = this.size;
            clone.keys = Arrays.copyOf(this.keys, this.keys.length);
            clone.children = Arrays.copyOf(this.children, this.children.length);
            for (int i = 0; i < this.size; ++i) {
                clone.children[i] = this.children[i].copy();
            }
            return clone;
        }
    }

    private static class Node4<V>
    extends InternalNode<V> {
        private byte k0;
        private byte k1;
        private byte k2;
        private byte k3;
        private @Nullable Node<V> c0;
        private @Nullable Node<V> c1;
        private @Nullable Node<V> c2;
        private @Nullable Node<V> c3;
        private byte size = 0;

        Node4(byte[] partialKey) {
            super(partialKey);
        }

        @Override
        @Nullable Node<V> getChild(byte key) {
            if (this.size > 0 && this.k0 == key) {
                return this.c0;
            }
            if (this.size > 1 && this.k1 == key) {
                return this.c1;
            }
            if (this.size > 2 && this.k2 == key) {
                return this.c2;
            }
            if (this.size > 3 && this.k3 == key) {
                return this.c3;
            }
            return null;
        }

        @Override
        @Nullable InternalNode<V> addChild(byte key, Node<V> child) {
            if (this.size > 0 && this.k0 == key) {
                this.c0 = child;
                return null;
            }
            if (this.size > 1 && this.k1 == key) {
                this.c1 = child;
                return null;
            }
            if (this.size > 2 && this.k2 == key) {
                this.c2 = child;
                return null;
            }
            if (this.size > 3 && this.k3 == key) {
                this.c3 = child;
                return null;
            }
            if (this.size == 4) {
                Node16<V> node = new Node16<V>(this.partialKey);
                node.value = this.value;
                node.addChild(this.k0, this.c0);
                node.addChild(this.k1, this.c1);
                node.addChild(this.k2, this.c2);
                node.addChild(this.k3, this.c3);
                node.addChild(key, child);
                return node;
            }
            byte keyByte = (byte)(key & 0xFF);
            if (this.size == 0) {
                this.k0 = keyByte;
                this.c0 = child;
            } else if (this.size == 1) {
                if (keyByte < (this.k0 & 0xFF)) {
                    this.k1 = this.k0;
                    this.c1 = this.c0;
                    this.k0 = keyByte;
                    this.c0 = child;
                } else {
                    this.k1 = keyByte;
                    this.c1 = child;
                }
            } else if (this.size == 2) {
                if (keyByte < (this.k0 & 0xFF)) {
                    this.k2 = this.k1;
                    this.c2 = this.c1;
                    this.k1 = this.k0;
                    this.c1 = this.c0;
                    this.k0 = keyByte;
                    this.c0 = child;
                } else if (keyByte < (this.k1 & 0xFF)) {
                    this.k2 = this.k1;
                    this.c2 = this.c1;
                    this.k1 = keyByte;
                    this.c1 = child;
                } else {
                    this.k2 = keyByte;
                    this.c2 = child;
                }
            } else if (keyByte < (this.k0 & 0xFF)) {
                this.k3 = this.k2;
                this.c3 = this.c2;
                this.k2 = this.k1;
                this.c2 = this.c1;
                this.k1 = this.k0;
                this.c1 = this.c0;
                this.k0 = keyByte;
                this.c0 = child;
            } else if (keyByte < (this.k1 & 0xFF)) {
                this.k3 = this.k2;
                this.c3 = this.c2;
                this.k2 = this.k1;
                this.c2 = this.c1;
                this.k1 = keyByte;
                this.c1 = child;
            } else if (keyByte < (this.k2 & 0xFF)) {
                this.k3 = this.k2;
                this.c3 = this.c2;
                this.k2 = keyByte;
                this.c2 = child;
            } else {
                this.k3 = keyByte;
                this.c3 = child;
            }
            this.size = (byte)(this.size + 1);
            return null;
        }

        @Override
        InternalNode<V> cloneWithNewKey(byte[] newKey) {
            Node4<V> clone = new Node4<V>(newKey);
            clone.value = this.value;
            clone.size = this.size;
            clone.k0 = this.k0;
            clone.k1 = this.k1;
            clone.k2 = this.k2;
            clone.k3 = this.k3;
            clone.c0 = this.c0;
            clone.c1 = this.c1;
            clone.c2 = this.c2;
            clone.c3 = this.c3;
            return clone;
        }

        @Override
        Node<V> copy() {
            Node4<V> clone = new Node4<V>(Arrays.copyOf(this.partialKey, this.partialKey.length));
            clone.value = this.value;
            clone.size = this.size;
            clone.k0 = this.k0;
            clone.k1 = this.k1;
            clone.k2 = this.k2;
            clone.k3 = this.k3;
            if (this.size > 0) {
                clone.c0 = this.c0.copy();
            }
            if (this.size > 1) {
                clone.c1 = this.c1.copy();
            }
            if (this.size > 2) {
                clone.c2 = this.c2.copy();
            }
            if (this.size > 3) {
                clone.c3 = this.c3.copy();
            }
            return clone;
        }
    }

    private static abstract class InternalNode<V>
    extends Node<V> {
        protected @Nullable V value;

        protected InternalNode(byte[] partialKey) {
            super(partialKey);
        }

        abstract @Nullable Node<V> getChild(byte var1);

        abstract @Nullable InternalNode<V> addChild(byte var1, Node<V> var2);

        @Override
        @Nullable V search(byte[] key, int depth) {
            if (this.partialKey.length == 0) {
                if (depth == key.length) {
                    return this.value;
                }
                Node<V> child = this.getChild(key[depth]);
                return child != null ? (V)child.search(key, depth + 1) : null;
            }
            if (!this.matchesPartialKey(key, depth)) {
                return null;
            }
            if ((depth += this.partialKey.length) == key.length) {
                return this.value;
            }
            Node<V> child = this.getChild(key[depth]);
            return child != null ? (V)child.search(key, depth + 1) : null;
        }

        @Override
        Node<V> insert(byte[] key, int depth, V value) {
            InternalNode<V> grown;
            if (!this.matchesPartialKey(key, depth)) {
                InternalNode grown2;
                int commonPrefix = InternalNode.findCommonPrefixLength(key, depth, this.partialKey);
                byte[] commonKey = Arrays.copyOfRange(key, depth, depth + commonPrefix);
                Node4 newNode = new Node4(commonKey);
                int remainingCurrentLength = this.partialKey.length - commonPrefix;
                if (remainingCurrentLength > 0) {
                    byte firstByte = this.partialKey[commonPrefix];
                    InternalNode<V> currentNodeCopy = this.cloneWithNewKey(Arrays.copyOfRange(this.partialKey, commonPrefix + 1, this.partialKey.length));
                    grown2 = newNode.addChild(firstByte, currentNodeCopy);
                    if (grown2 != null) {
                        newNode = (Node4)grown2;
                    }
                } else {
                    newNode.value = this.value;
                    for (int i = 0; i < 256; ++i) {
                        Node<V> child = this.getChild((byte)i);
                        if (child == null || (grown2 = newNode.addChild((byte)i, child)) == null) continue;
                        newNode = (Node4)grown2;
                    }
                }
                int remainingNewLength = key.length - (depth + commonPrefix);
                if (remainingNewLength > 0) {
                    byte firstByte = key[depth + commonPrefix];
                    LeafNode<V> leafNode = new LeafNode<V>(Arrays.copyOfRange(key, depth + commonPrefix + 1, key.length), value);
                    Node4 grown3 = newNode.addChild(firstByte, leafNode);
                    return grown3 != null ? grown3 : newNode;
                }
                newNode.value = value;
                return newNode;
            }
            if ((depth += this.partialKey.length) == key.length) {
                this.value = value;
                return this;
            }
            byte nextByte = key[depth];
            Node<V> child = this.getChild(nextByte);
            if (child == null) {
                byte[] remainingKey = Arrays.copyOfRange(key, depth + 1, key.length);
                LeafNode<V> newChild = new LeafNode<V>(remainingKey, value);
                InternalNode grown4 = this.addChild(nextByte, newChild);
                return grown4 != null ? grown4 : this;
            }
            Node<V> newChild = child.insert(key, depth + 1, value);
            if (newChild != child && (grown = this.addChild(nextByte, newChild)) != null) {
                grown.partialKey = this.partialKey;
                grown.value = this.value;
                return grown;
            }
            return this;
        }

        abstract InternalNode<V> cloneWithNewKey(byte[] var1);
    }
}

