/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.shaded.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.openrewrite.shaded.jgit.api.GitCommand;
import org.openrewrite.shaded.jgit.api.ReflogCommand;
import org.openrewrite.shaded.jgit.api.errors.GitAPIException;
import org.openrewrite.shaded.jgit.api.errors.InvalidRefNameException;
import org.openrewrite.shaded.jgit.api.errors.JGitInternalException;
import org.openrewrite.shaded.jgit.internal.JGitText;
import org.openrewrite.shaded.jgit.lib.ReflogEntry;
import org.openrewrite.shaded.jgit.lib.Repository;
import org.openrewrite.shaded.jgit.revwalk.RevCommit;
import org.openrewrite.shaded.jgit.revwalk.RevWalk;

public class StashListCommand
extends GitCommand<Collection<RevCommit>> {
    public StashListCommand(Repository repo) {
        super(repo);
    }

    @Override
    public Collection<RevCommit> call() throws GitAPIException, InvalidRefNameException {
        this.checkCallable();
        try {
            if (this.repo.exactRef("refs/stash") == null) {
                return Collections.emptyList();
            }
        }
        catch (IOException e) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().cannotRead, "refs/stash"), e);
        }
        ReflogCommand refLog = new ReflogCommand(this.repo);
        refLog.setRef("refs/stash");
        Object stashEntries = refLog.call();
        if (stashEntries.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RevCommit> stashCommits = new ArrayList<RevCommit>(stashEntries.size());
        Throwable throwable = null;
        Object var5_7 = null;
        try (RevWalk walk = new RevWalk(this.repo);){
            Iterator iterator = stashEntries.iterator();
            while (iterator.hasNext()) {
                ReflogEntry entry = (ReflogEntry)iterator.next();
                try {
                    stashCommits.add(walk.parseCommit(entry.getNewId()));
                }
                catch (IOException e) {
                    throw new JGitInternalException(MessageFormat.format(JGitText.get().cannotReadCommit, entry.getNewId()), e);
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return stashCommits;
    }
}

