/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.table;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

@JsonIgnoreType
public class ParseFailures
extends DataTable<Row> {
    public ParseFailures(Recipe recipe) {
        super(recipe, "Parser failures", "A list of files that failed to parse along with stack traces of their failures.");
    }

    public static final class Row {
        @Column(displayName="Parser", description="The parser implementation that failed.")
        private final String parser;
        @Column(displayName="Source path", description="The file that failed to parse.")
        private final String sourcePath;
        @Column(displayName="Exception type", description="The class name of the exception that produce the parse failure.")
        @Nullable
        private final String exceptionType;
        @Column(displayName="Tree type", description="The type of the tree element that was being parsed when the failure occurred. This can refer either to the intended target OpenRewrite Tree type or a parser or compiler internal tree type that we couldn't determine how to map.")
        @Nullable
        private final String treeType;
        @Column(displayName="Snippet", description="The code snippet that the failure occurred on. Omitted when the parser fails on the whole file.")
        @Nullable
        private final String snippet;
        @Column(displayName="Stack trace", description="The stack trace of the failure.")
        private final String stackTrace;

        public Row(String parser, String sourcePath, @Nullable String exceptionType, @Nullable String treeType, @Nullable String snippet, String stackTrace) {
            this.parser = parser;
            this.sourcePath = sourcePath;
            this.exceptionType = exceptionType;
            this.treeType = treeType;
            this.snippet = snippet;
            this.stackTrace = stackTrace;
        }

        public String getParser() {
            return this.parser;
        }

        public String getSourcePath() {
            return this.sourcePath;
        }

        @Nullable
        public String getExceptionType() {
            return this.exceptionType;
        }

        @Nullable
        public String getTreeType() {
            return this.treeType;
        }

        @Nullable
        public String getSnippet() {
            return this.snippet;
        }

        public String getStackTrace() {
            return this.stackTrace;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            String this$parser = this.getParser();
            String other$parser = other.getParser();
            if (this$parser == null ? other$parser != null : !this$parser.equals(other$parser)) {
                return false;
            }
            String this$sourcePath = this.getSourcePath();
            String other$sourcePath = other.getSourcePath();
            if (this$sourcePath == null ? other$sourcePath != null : !this$sourcePath.equals(other$sourcePath)) {
                return false;
            }
            String this$exceptionType = this.getExceptionType();
            String other$exceptionType = other.getExceptionType();
            if (this$exceptionType == null ? other$exceptionType != null : !this$exceptionType.equals(other$exceptionType)) {
                return false;
            }
            String this$treeType = this.getTreeType();
            String other$treeType = other.getTreeType();
            if (this$treeType == null ? other$treeType != null : !this$treeType.equals(other$treeType)) {
                return false;
            }
            String this$snippet = this.getSnippet();
            String other$snippet = other.getSnippet();
            if (this$snippet == null ? other$snippet != null : !this$snippet.equals(other$snippet)) {
                return false;
            }
            String this$stackTrace = this.getStackTrace();
            String other$stackTrace = other.getStackTrace();
            return !(this$stackTrace == null ? other$stackTrace != null : !this$stackTrace.equals(other$stackTrace));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $parser = this.getParser();
            result = result * 59 + ($parser == null ? 43 : $parser.hashCode());
            String $sourcePath = this.getSourcePath();
            result = result * 59 + ($sourcePath == null ? 43 : $sourcePath.hashCode());
            String $exceptionType = this.getExceptionType();
            result = result * 59 + ($exceptionType == null ? 43 : $exceptionType.hashCode());
            String $treeType = this.getTreeType();
            result = result * 59 + ($treeType == null ? 43 : $treeType.hashCode());
            String $snippet = this.getSnippet();
            result = result * 59 + ($snippet == null ? 43 : $snippet.hashCode());
            String $stackTrace = this.getStackTrace();
            result = result * 59 + ($stackTrace == null ? 43 : $stackTrace.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "ParseFailures.Row(parser=" + this.getParser() + ", sourcePath=" + this.getSourcePath() + ", exceptionType=" + this.getExceptionType() + ", treeType=" + this.getTreeType() + ", snippet=" + this.getSnippet() + ", stackTrace=" + this.getStackTrace() + ")";
        }
    }
}

