/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.shaded.jgit.internal.storage.file;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import java.util.Arrays;

final class BitSet {
    private long[] words;

    BitSet(int initialCapacity) {
        this.words = new long[BitSet.block(initialCapacity) + 1];
    }

    final void clear() {
        Arrays.fill(this.words, 0L);
    }

    final void set(int position) {
        int block = BitSet.block(position);
        if (block >= this.words.length) {
            long[] buf = new long[2 * BitSet.block(position)];
            System.arraycopy(this.words, 0, buf, 0, this.words.length);
            this.words = buf;
        }
        int n = block;
        this.words[n] = this.words[n] | BitSet.mask(position);
    }

    final void clear(int position) {
        int block = BitSet.block(position);
        if (block < this.words.length) {
            int n = block;
            this.words[n] = this.words[n] & (BitSet.mask(position) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    final boolean get(int position) {
        int block = BitSet.block(position);
        return block < this.words.length && (this.words[block] & BitSet.mask(position)) != 0L;
    }

    final EWAHCompressedBitmap toEWAHCompressedBitmap() {
        EWAHCompressedBitmap compressed = new EWAHCompressedBitmap(this.words.length);
        int runningEmptyWords = 0;
        long lastNonEmptyWord = 0L;
        long[] lArray = this.words;
        int n = this.words.length;
        int n2 = 0;
        while (n2 < n) {
            long word = lArray[n2];
            if (word == 0L) {
                ++runningEmptyWords;
            } else {
                if (lastNonEmptyWord != 0L) {
                    compressed.addWord(lastNonEmptyWord);
                }
                if (runningEmptyWords > 0) {
                    compressed.addStreamOfEmptyWords(false, (long)runningEmptyWords);
                    runningEmptyWords = 0;
                }
                lastNonEmptyWord = word;
            }
            ++n2;
        }
        int bitsThatMatter = 64 - Long.numberOfLeadingZeros(lastNonEmptyWord);
        if (bitsThatMatter > 0) {
            compressed.addWord(lastNonEmptyWord, bitsThatMatter);
        }
        return compressed;
    }

    private static final int block(int position) {
        return position >> 6;
    }

    private static final long mask(int position) {
        return 1L << position;
    }
}

