/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.quark;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.quark.Quark;

public class QuarkParser
implements Parser {
    public static Stream<SourceFile> parseAllOtherFiles(final Path rootDir, List<SourceFile> sourceFiles) throws IOException {
        final Stack<List<PathMatcher>> gitignores = new Stack<List<PathMatcher>>();
        QuarkParser.parseGitignore(new File(System.getProperty("user.home") + "/.gitignore"), gitignores);
        final HashSet<Path> sourceFilePaths = new HashSet<Path>();
        for (SourceFile sourceFile : sourceFiles) {
            sourceFilePaths.add(sourceFile.getSourcePath());
        }
        final ArrayList<Path> quarks = new ArrayList<Path>();
        Files.walkFileTree(rootDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (this.isIgnored(dir)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                QuarkParser.parseGitignore(dir.resolve(".gitignore").toFile(), gitignores);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (!(attrs.isSymbolicLink() || attrs.isOther() || sourceFilePaths.contains(rootDir.relativize(file)) || this.isIgnored(file))) {
                    quarks.add(file);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                if (dir.resolve(".gitignore").toFile().exists()) {
                    gitignores.pop();
                }
                return FileVisitResult.CONTINUE;
            }

            private boolean isIgnored(Path path) {
                for (List gitignore : gitignores) {
                    for (PathMatcher gitignoreLine : gitignore) {
                        if (!gitignoreLine.matches(path)) continue;
                        return true;
                    }
                }
                return false;
            }
        });
        return new QuarkParser().parse(quarks, rootDir, new InMemoryExecutionContext());
    }

    private static void parseGitignore(File gitignore, Stack<List<PathMatcher>> gitignores) throws IOException {
        if (gitignore.exists()) {
            try (FileInputStream fis = new FileInputStream(gitignore);
                 BufferedReader reader = new BufferedReader(new InputStreamReader(fis));){
                String line;
                ArrayList<PathMatcher> gitignorePaths = new ArrayList<PathMatcher>();
                while ((line = reader.readLine()) != null) {
                    if (line.trim().startsWith("#") || StringUtils.isBlank(line)) continue;
                    gitignorePaths.add(gitignore.toPath().getFileSystem().getPathMatcher("glob:**/" + line.trim() + (line.trim().endsWith("/") ? "**" : "")));
                }
                gitignores.add(gitignorePaths);
            }
        }
    }

    @Override
    public Stream<SourceFile> parseInputs(Iterable<Parser.Input> sources, @Nullable Path relativeTo, ExecutionContext ctx) {
        return StreamSupport.stream(sources.spliterator(), false).map(source -> new Quark(Tree.randomId(), source.getRelativePath(relativeTo), Markers.EMPTY, null, source.getFileAttributes()));
    }

    @Override
    public boolean accept(Path path) {
        return true;
    }

    @Override
    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("file");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Parser.Builder {
        public Builder() {
            super(Quark.class);
        }

        @Override
        public QuarkParser build() {
            return new QuarkParser();
        }

        @Override
        public String getDslName() {
            return "other";
        }
    }
}

