/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.openrewrite.Incubating;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.RecipesThatMadeChanges;
import org.openrewrite.shaded.jgit.diff.DiffEntry;
import org.openrewrite.shaded.jgit.diff.DiffFormatter;
import org.openrewrite.shaded.jgit.diff.RawTextComparator;
import org.openrewrite.shaded.jgit.internal.storage.dfs.DfsRepositoryDescription;
import org.openrewrite.shaded.jgit.internal.storage.dfs.InMemoryRepository;
import org.openrewrite.shaded.jgit.lib.AbbreviatedObjectId;
import org.openrewrite.shaded.jgit.lib.FileMode;
import org.openrewrite.shaded.jgit.lib.ObjectId;
import org.openrewrite.shaded.jgit.lib.ObjectInserter;

public class Result {
    @Nullable
    private final SourceFile before;
    @Nullable
    private final SourceFile after;
    private final Collection<List<Recipe>> recipes;
    @Nullable
    private final Duration timeSavings;

    public Result(@Nullable SourceFile before, @Nullable SourceFile after, Collection<List<Recipe>> recipes) {
        this.before = before;
        this.after = after;
        this.recipes = recipes;
        Duration timeSavings = null;
        for (List<Recipe> recipesStack : recipes) {
            Duration perOccurrence;
            if (recipesStack == null || recipesStack.isEmpty() || (perOccurrence = recipesStack.get(recipesStack.size() - 1).getEstimatedEffortPerOccurrence()) == null) continue;
            timeSavings = perOccurrence;
            break;
        }
        this.timeSavings = timeSavings;
    }

    public Result(@Nullable SourceFile before, SourceFile after) {
        this(before, after, after.getMarkers().findFirst(RecipesThatMadeChanges.class).orElseThrow(() -> new IllegalStateException("SourceFile changed but no recipe reported making a change")).getRecipes());
    }

    public List<RecipeDescriptor> getRecipeDescriptorsThatMadeChanges() {
        ArrayList<RecipeDescriptor> recipesToDisplay = new ArrayList<RecipeDescriptor>();
        for (List<Recipe> currentStack : this.recipes) {
            RecipeDescriptor index;
            Recipe root = currentStack.size() > 1 ? currentStack.get(1) : currentStack.get(0);
            RecipeDescriptor rootDescriptor = root.getDescriptor().withRecipeList(new ArrayList<RecipeDescriptor>());
            if (recipesToDisplay.contains(rootDescriptor)) {
                index = (RecipeDescriptor)recipesToDisplay.get(recipesToDisplay.indexOf(rootDescriptor));
            } else {
                recipesToDisplay.add(rootDescriptor);
                index = rootDescriptor;
            }
            for (int i = 2; i < currentStack.size(); ++i) {
                RecipeDescriptor nextDescriptor = currentStack.get(i).getDescriptor().withRecipeList(new ArrayList<RecipeDescriptor>());
                if (index.getRecipeList().contains(nextDescriptor)) {
                    index = index.getRecipeList().get(index.getRecipeList().indexOf(nextDescriptor));
                    continue;
                }
                index.getRecipeList().add(nextDescriptor);
                index = nextDescriptor;
            }
        }
        return recipesToDisplay;
    }

    public String diff() {
        return this.diff(null);
    }

    public String diff(@Nullable Path relativeTo) {
        return this.diff(relativeTo, null);
    }

    public String diff(@Nullable Path relativeTo, @Nullable PrintOutputCapture.MarkerPrinter markerPrinter) {
        return this.diff(relativeTo, markerPrinter, false);
    }

    @Incubating(since="7.34.0")
    public String diff(@Nullable Path relativeTo, @Nullable PrintOutputCapture.MarkerPrinter markerPrinter, @Nullable Boolean ignoreAllWhitespace) {
        Path beforePath = this.before == null ? null : this.before.getSourcePath();
        Path afterPath = null;
        if (this.before == null && this.after == null) {
            afterPath = (relativeTo == null ? Paths.get(".", new String[0]) : relativeTo).resolve("partial-" + System.nanoTime());
        } else if (this.after != null) {
            afterPath = this.after.getSourcePath();
        }
        PrintOutputCapture<Integer> out = markerPrinter == null ? new PrintOutputCapture<Integer>(0) : new PrintOutputCapture<Integer>(0, markerPrinter);
        FileMode beforeMode = this.before != null && this.before.getFileAttributes() != null && this.before.getFileAttributes().isExecutable() ? FileMode.EXECUTABLE_FILE : FileMode.REGULAR_FILE;
        FileMode afterMode = this.after != null && this.after.getFileAttributes() != null && this.after.getFileAttributes().isExecutable() ? FileMode.EXECUTABLE_FILE : FileMode.REGULAR_FILE;
        HashSet<Recipe> recipeSet = new HashSet<Recipe>(this.recipes.size());
        for (List<Recipe> rs : this.recipes) {
            if (rs.isEmpty()) continue;
            recipeSet.add(rs.get(0));
        }
        try (InMemoryDiffEntry diffEntry = new InMemoryDiffEntry(beforePath, afterPath, relativeTo, this.before == null ? "" : this.before.printAll(out), this.after == null ? "" : this.after.printAll(out.clone()), recipeSet, beforeMode, afterMode);){
            String string = diffEntry.getDiff(ignoreAllWhitespace);
            return string;
        }
    }

    public String toString() {
        return this.diff();
    }

    @Nullable
    public SourceFile getBefore() {
        return this.before;
    }

    @Nullable
    public SourceFile getAfter() {
        return this.after;
    }

    public Collection<List<Recipe>> getRecipes() {
        return this.recipes;
    }

    @Nullable
    public Duration getTimeSavings() {
        return this.timeSavings;
    }

    static class InMemoryDiffEntry
    extends DiffEntry
    implements AutoCloseable {
        static final AbbreviatedObjectId A_ZERO = AbbreviatedObjectId.fromObjectId(ObjectId.zeroId());
        private final InMemoryRepository repo;
        private final Set<Recipe> recipesThatMadeChanges;

        InMemoryDiffEntry(@Nullable Path originalFilePath, @Nullable Path filePath, @Nullable Path relativeTo, String oldSource, String newSource, Set<Recipe> recipesThatMadeChanges) {
            this(originalFilePath, filePath, relativeTo, oldSource, newSource, recipesThatMadeChanges, FileMode.REGULAR_FILE, FileMode.REGULAR_FILE);
        }

        InMemoryDiffEntry(@Nullable Path originalFilePath, @Nullable Path filePath, @Nullable Path relativeTo, String oldSource, String newSource, Set<Recipe> recipesThatMadeChanges, FileMode oldMode, FileMode newMode) {
            this.recipesThatMadeChanges = recipesThatMadeChanges;
            try {
                this.repo = ((InMemoryRepository.Builder)new InMemoryRepository.Builder().setRepositoryDescription(new DfsRepositoryDescription())).build();
                try (ObjectInserter inserter = this.repo.getObjectDatabase().newInserter();){
                    if (originalFilePath != null) {
                        this.oldId = inserter.insert(3, oldSource.getBytes(StandardCharsets.UTF_8)).abbreviate(40);
                        this.oldMode = oldMode;
                        this.oldPath = (relativeTo == null ? originalFilePath : relativeTo.relativize(originalFilePath)).toString().replace("\\", "/");
                    } else {
                        this.oldId = A_ZERO;
                        this.oldMode = FileMode.MISSING;
                        this.oldPath = "/dev/null";
                    }
                    if (filePath != null) {
                        this.newId = inserter.insert(3, newSource.getBytes(StandardCharsets.UTF_8)).abbreviate(40);
                        this.newMode = newMode;
                        this.newPath = (relativeTo == null ? filePath : relativeTo.relativize(filePath)).toString().replace("\\", "/");
                    } else {
                        this.newId = A_ZERO;
                        this.newMode = FileMode.MISSING;
                        this.newPath = "/dev/null";
                    }
                    inserter.flush();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            this.changeType = this.oldMode == FileMode.MISSING && this.newMode != FileMode.MISSING ? DiffEntry.ChangeType.ADD : (this.oldMode != FileMode.MISSING && this.newMode == FileMode.MISSING ? DiffEntry.ChangeType.DELETE : (!this.oldPath.equals(this.newPath) ? DiffEntry.ChangeType.RENAME : DiffEntry.ChangeType.MODIFY));
        }

        String getDiff() {
            return this.getDiff(false);
        }

        String getDiff(@Nullable Boolean ignoreAllWhitespace) {
            if (ignoreAllWhitespace == null) {
                ignoreAllWhitespace = false;
            }
            if (this.oldId.equals(this.newId) && this.oldPath.equals(this.newPath)) {
                return "";
            }
            ByteArrayOutputStream patch = new ByteArrayOutputStream();
            try (DiffFormatter formatter = new DiffFormatter(patch);){
                formatter.setDiffComparator(ignoreAllWhitespace != false ? RawTextComparator.WS_IGNORE_ALL : RawTextComparator.DEFAULT);
                formatter.setRepository(this.repo);
                formatter.format(this);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            String diff = patch.toString();
            AtomicBoolean addedComment = new AtomicBoolean(false);
            return Arrays.stream(diff.split("\n")).map(l -> {
                if (!addedComment.get() && l.startsWith("@@") && l.endsWith("@@")) {
                    addedComment.set(true);
                    LinkedHashSet<String> sortedRecipeNames = new LinkedHashSet<String>();
                    for (Recipe recipesThatMadeChange : this.recipesThatMadeChanges) {
                        sortedRecipeNames.add(recipesThatMadeChange.getName());
                    }
                    StringJoiner joinedRecipeNames = new StringJoiner(", ", " ", "");
                    for (String name : sortedRecipeNames) {
                        joinedRecipeNames.add(name);
                    }
                    return l + joinedRecipeNames;
                }
                return l;
            }).collect(Collectors.joining("\n")) + "\n";
        }

        @Override
        public void close() {
            this.repo.close();
        }
    }
}

