/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.Objects;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FailureLogAnalyzer;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.BuildToolFailure;
import org.openrewrite.marker.Markup;
import org.openrewrite.table.BuildToolFailures;

public final class FindBuildToolFailures
extends Recipe {
    private final transient BuildToolFailures failures = new BuildToolFailures(this);
    @Option(displayName="Suppress log output", description="Default false. If true, the `logOutput` column will be empty in the output table.", required=false)
    @Nullable
    private final Boolean suppressLogOutput;

    @Override
    public String getDisplayName() {
        return "Find source files with `BuildToolFailure` markers";
    }

    @Override
    public String getDescription() {
        return "This recipe explores build tool failures after an LST is produced for classifying the types of failures that can occur and prioritizing fixes according to the most common problems.";
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                SourceFile sourceFile = (SourceFile)Objects.requireNonNull(tree);
                return sourceFile.getMarkers().findFirst(BuildToolFailure.class).map(failure -> {
                    String logFileContents = sourceFile.printAll();
                    String requiredJavaVersion = FailureLogAnalyzer.requiredJavaVersion(logFileContents);
                    if (FindBuildToolFailures.this.suppressLogOutput != null && FindBuildToolFailures.this.suppressLogOutput.booleanValue()) {
                        logFileContents = "";
                    }
                    FindBuildToolFailures.this.failures.insertRow(ctx, new BuildToolFailures.Row(failure.getType(), failure.getVersion(), failure.getCommand(), failure.getExitCode(), requiredJavaVersion, logFileContents));
                    return Markup.info(sourceFile, String.format("Exit code %d", failure.getExitCode()));
                }).orElse(sourceFile);
            }
        };
    }

    public FindBuildToolFailures(@Nullable Boolean suppressLogOutput) {
        this.suppressLogOutput = suppressLogOutput;
    }

    public BuildToolFailures getFailures() {
        return this.failures;
    }

    @Nullable
    public Boolean getSuppressLogOutput() {
        return this.suppressLogOutput;
    }

    @NonNull
    public String toString() {
        return "FindBuildToolFailures(failures=" + this.getFailures() + ", suppressLogOutput=" + this.getSuppressLogOutput() + ")";
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindBuildToolFailures)) {
            return false;
        }
        FindBuildToolFailures other = (FindBuildToolFailures)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$suppressLogOutput = this.getSuppressLogOutput();
        Boolean other$suppressLogOutput = other.getSuppressLogOutput();
        return !(this$suppressLogOutput == null ? other$suppressLogOutput != null : !((Object)this$suppressLogOutput).equals(other$suppressLogOutput));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindBuildToolFailures;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $suppressLogOutput = this.getSuppressLogOutput();
        result = result * 59 + ($suppressLogOutput == null ? 43 : ((Object)$suppressLogOutput).hashCode());
        return result;
    }
}

