/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.openrewrite.internal.lang.Nullable;

class FailureLogAnalyzer {
    private static final Pattern UNSUPPORTED_CLASS_FILE_MAJOR_VERSION = Pattern.compile("Unsupported class file (?:major )?version (\\d+)", 2);
    private static final Pattern SOURCE_TARGET_OPTION = Pattern.compile("(?:Source|Target) option (\\d+) is no longer supported. Use \\d+ or later", 2);
    private static final Pattern CLASS_FILE_MAJOR_VERSION = Pattern.compile("class file (?:major )?version (\\d+)");
    private static final String INVALID_FLAG_RELEASE = "invalid flag: --release";
    private static final String ADD_EXPORTS = "Unrecognized option: --add-exports";
    private static final String MODULE_PATH = "javac: invalid flag: --module-path";
    private static final Pattern BAD_OPTION_WAS_IGNORED = Pattern.compile("bad option '-target:(\\d+)' was ignored");
    private static final Pattern INCOMPATIBLE_COMPONENT = Pattern.compile("Incompatible because this component declares a component compatible with Java (\\d+)");
    private static final Pattern INVALID_SOURCE_TARGET_RELEASE = Pattern.compile("invalid (?:source|target) release: (?:1\\.)?(\\d+)");
    private static final Pattern RELEASE_VERSION_NOT_SUPPORTED = Pattern.compile("release version (\\d+) not supported");
    private static final Pattern SOURCE_TARGET_OBSOLETE = Pattern.compile("(?:source|target) value (?:1\\.)?(\\d+) is obsolete", 2);
    private static final Pattern TOOLCHAIN = Pattern.compile("\\[ERROR] jdk \\[ version='(?:1\\.)?(\\d+)' ]");
    private static final Pattern USE_SOURCE = Pattern.compile("use -source (\\d+) or higher to enable");

    FailureLogAnalyzer() {
    }

    @Nullable
    static String requiredJavaVersion(String logFileContents) {
        Matcher matcher = UNSUPPORTED_CLASS_FILE_MAJOR_VERSION.matcher(logFileContents);
        if (matcher.find()) {
            return "8";
        }
        matcher = SOURCE_TARGET_OPTION.matcher(logFileContents);
        if (matcher.find()) {
            return matcher.group(1);
        }
        matcher = CLASS_FILE_MAJOR_VERSION.matcher(logFileContents);
        if (matcher.find()) {
            return String.valueOf(Integer.parseInt(matcher.group(1)) - 44);
        }
        if (logFileContents.contains(INVALID_FLAG_RELEASE) || logFileContents.contains(ADD_EXPORTS) || logFileContents.contains(MODULE_PATH)) {
            return "11";
        }
        return Stream.of(BAD_OPTION_WAS_IGNORED, INCOMPATIBLE_COMPONENT, INVALID_SOURCE_TARGET_RELEASE, RELEASE_VERSION_NOT_SUPPORTED, SOURCE_TARGET_OBSOLETE, TOOLCHAIN, USE_SOURCE).map(pattern -> pattern.matcher(logFileContents)).filter(Matcher::find).map(m -> m.group(1)).findFirst().orElse(null);
    }
}

