/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.quark;

import java.util.function.UnaryOperator;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.quark.Quark;
import org.openrewrite.quark.QuarkVisitor;

public class QuarkPrinter<P>
extends QuarkVisitor<PrintOutputCapture<P>> {
    private static final UnaryOperator<String> QUARK_MARKER_WRAPPER = out -> "~~" + out + (out.isEmpty() ? "" : "~~") + ">";

    @Override
    public Quark visitQuark(Quark quark, PrintOutputCapture<P> p) {
        this.beforeSyntax(quark.getMarkers(), p);
        if (!p.out.toString().isEmpty()) {
            p.append("\u269b\u269b\u269b The contents of this file are not visible. \u269b\u269b\u269b");
        }
        this.afterSyntax(quark.getMarkers(), p);
        return quark;
    }

    private void beforeSyntax(Markers markers, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(this.getCursor(), marker), QUARK_MARKER_WRAPPER));
        }
        this.visitMarkers(markers, p);
        for (Marker marker : markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), marker), QUARK_MARKER_WRAPPER));
        }
    }

    private void afterSyntax(Markers markers, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(this.getCursor(), marker), QUARK_MARKER_WRAPPER));
        }
    }
}

