/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marker;

import java.util.Objects;
import java.util.UUID;
import java.util.function.UnaryOperator;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.RecipeScheduler;
import org.openrewrite.Tree;
import org.openrewrite.internal.ExceptionUtils;
import org.openrewrite.internal.RecipeRunException;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;

@Incubating(since="7.31.0")
public interface Markup
extends Marker {
    public String getMessage();

    @Nullable
    public String getDetail();

    @Override
    default public String print(Cursor cursor, UnaryOperator<String> commentWrapper, boolean verbose) {
        if (verbose) {
            return (String)commentWrapper.apply("(" + this.getDetail() + ")");
        }
        return (String)commentWrapper.apply("(" + this.getMessage() + ")");
    }

    public static <T extends Tree> T error(T t, Throwable throwable) {
        return Markup.markup(t, new Error(Tree.randomId(), throwable));
    }

    public static <T extends Tree> T warn(T t, Throwable throwable) {
        return Markup.markup(t, new Warn(Tree.randomId(), throwable));
    }

    public static <T extends Tree> T info(T t, String message) {
        return Markup.info(t, message, null);
    }

    public static <T extends Tree> T info(T t, String message, @Nullable String detail) {
        return Markup.markup(t, new Info(Tree.randomId(), message, detail));
    }

    public static <T extends Tree> T debug(T t, String message) {
        return Markup.debug(t, message, null);
    }

    public static <T extends Tree> T debug(T t, String message, @Nullable String detail) {
        return Markup.markup(t, new Debug(Tree.randomId(), message, detail));
    }

    public static <T extends Tree> T markup(T t, Markup markup) {
        return t.withMarkers(t.getMarkers().compute(markup, (s1, s2) -> s1 == null ? s2 : s1));
    }

    public static final class Error
    implements Markup {
        private final UUID id;
        private final Throwable exception;

        @Override
        public String getMessage() {
            return this.getCause().getMessage();
        }

        @Override
        @NonNull
        public String getDetail() {
            return ExceptionUtils.sanitizeStackTrace(this.getCause(), RecipeScheduler.class);
        }

        private Throwable getCause() {
            return this.exception instanceof RecipeRunException ? this.exception.getCause() : this.exception;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Error error = (Error)o;
            return this.getDetail().equals(error.getDetail());
        }

        public int hashCode() {
            return Objects.hash(this.getDetail());
        }

        public Error(UUID id, Throwable exception) {
            this.id = id;
            this.exception = exception;
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        public Throwable getException() {
            return this.exception;
        }

        @NonNull
        public String toString() {
            return "Markup.Error(id=" + this.getId() + ", exception=" + this.getException() + ")";
        }

        @NonNull
        public Error withId(UUID id) {
            return this.id == id ? this : new Error(id, this.exception);
        }

        @NonNull
        public Error withException(Throwable exception) {
            return this.exception == exception ? this : new Error(this.id, exception);
        }
    }

    public static final class Warn
    implements Markup {
        private final UUID id;
        private final Throwable exception;

        @Override
        public String getMessage() {
            return this.getCause().getMessage();
        }

        @Override
        @NonNull
        public String getDetail() {
            return ExceptionUtils.sanitizeStackTrace(this.getCause(), RecipeScheduler.class);
        }

        private Throwable getCause() {
            return this.exception instanceof RecipeRunException ? this.exception.getCause() : this.exception;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Warn error = (Warn)o;
            return this.getDetail().equals(error.getDetail());
        }

        public int hashCode() {
            return Objects.hash(this.getDetail());
        }

        public Warn(UUID id, Throwable exception) {
            this.id = id;
            this.exception = exception;
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        public Throwable getException() {
            return this.exception;
        }

        @NonNull
        public String toString() {
            return "Markup.Warn(id=" + this.getId() + ", exception=" + this.getException() + ")";
        }

        @NonNull
        public Warn withId(UUID id) {
            return this.id == id ? this : new Warn(id, this.exception);
        }

        @NonNull
        public Warn withException(Throwable exception) {
            return this.exception == exception ? this : new Warn(this.id, exception);
        }
    }

    public static final class Info
    implements Markup {
        private final UUID id;
        private final String message;
        @Nullable
        private final String detail;

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        @Nullable
        public String getDetail() {
            return this.detail;
        }

        public Info(UUID id, String message, @Nullable String detail) {
            this.id = id;
            this.message = message;
            this.detail = detail;
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        @NonNull
        public String toString() {
            return "Markup.Info(id=" + this.getId() + ", message=" + this.getMessage() + ", detail=" + this.getDetail() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Info)) {
                return false;
            }
            Info other = (Info)o;
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            String this$detail = this.getDetail();
            String other$detail = other.getDetail();
            return !(this$detail == null ? other$detail != null : !this$detail.equals(other$detail));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            String $detail = this.getDetail();
            result = result * 59 + ($detail == null ? 43 : $detail.hashCode());
            return result;
        }

        @NonNull
        public Info withId(UUID id) {
            return this.id == id ? this : new Info(id, this.message, this.detail);
        }

        @NonNull
        public Info withMessage(String message) {
            return this.message == message ? this : new Info(this.id, message, this.detail);
        }

        @NonNull
        public Info withDetail(@Nullable String detail) {
            return this.detail == detail ? this : new Info(this.id, this.message, detail);
        }
    }

    public static final class Debug
    implements Markup {
        private final UUID id;
        private final String message;
        @Nullable
        private final String detail;

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        @Nullable
        public String getDetail() {
            return this.detail;
        }

        public Debug(UUID id, String message, @Nullable String detail) {
            this.id = id;
            this.message = message;
            this.detail = detail;
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        @NonNull
        public String toString() {
            return "Markup.Debug(id=" + this.getId() + ", message=" + this.getMessage() + ", detail=" + this.getDetail() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Debug)) {
                return false;
            }
            Debug other = (Debug)o;
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            String this$detail = this.getDetail();
            String other$detail = other.getDetail();
            return !(this$detail == null ? other$detail != null : !this$detail.equals(other$detail));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            String $detail = this.getDetail();
            result = result * 59 + ($detail == null ? 43 : $detail.hashCode());
            return result;
        }

        @NonNull
        public Debug withId(UUID id) {
            return this.id == id ? this : new Debug(id, this.message, this.detail);
        }

        @NonNull
        public Debug withMessage(String message) {
            return this.message == message ? this : new Debug(this.id, message, this.detail);
        }

        @NonNull
        public Debug withDetail(@Nullable String detail) {
            return this.detail == detail ? this : new Debug(this.id, this.message, detail);
        }
    }
}

