/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.nio.file.FileSystems;
import java.nio.file.Path;

public class PathUtils {
    private static final String UNIX_SEPARATOR = "/";
    private static final String WINDOWS_SEPARATOR = "\\";

    private PathUtils() {
    }

    public static boolean equalIgnoringSeparators(Path a, Path b) {
        return PathUtils.equalIgnoringSeparators(a.normalize().toString(), b.normalize().toString());
    }

    public static boolean equalIgnoringSeparators(String a, String b) {
        return PathUtils.separatorsToSystem(a).equals(PathUtils.separatorsToSystem(b));
    }

    public static String separatorsToUnix(String path) {
        return path.contains(WINDOWS_SEPARATOR) ? path.replace(WINDOWS_SEPARATOR, UNIX_SEPARATOR) : path;
    }

    public static String separatorsToWindows(String path) {
        return path.contains(UNIX_SEPARATOR) ? path.replace(UNIX_SEPARATOR, WINDOWS_SEPARATOR) : path;
    }

    public static String separatorsToSystem(String path) {
        if (FileSystems.getDefault().getSeparator().equals(WINDOWS_SEPARATOR)) {
            return PathUtils.separatorsToWindows(path);
        }
        return PathUtils.separatorsToUnix(path);
    }
}

