/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.concurrent.atomic.AtomicBoolean;
import org.openrewrite.ExecutionContext;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.dependencies.AddDependency;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;

public class AddHamcrestJUnitDependency
extends ScanningRecipe<AtomicBoolean> {
    public String getDisplayName() {
        return "Add Hamcrest JUnit dependency";
    }

    public String getDescription() {
        return "Add Hamcrest JUnit dependency only if JUnit 4's `assertThat` or `assumeThat` is used.";
    }

    public AtomicBoolean getInitialValue(ExecutionContext ctx) {
        return new AtomicBoolean(false);
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final AtomicBoolean acc) {
        final MethodMatcher methodMatcher = new MethodMatcher("org.junit.Ass* *That(..)");
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree preVisit(Tree tree, ExecutionContext ctx) {
                this.stopAfterPreVisit();
                if (tree instanceof JavaSourceFile && !acc.get()) {
                    for (JavaType.Method type : ((JavaSourceFile)tree).getTypesInUse().getUsedMethods()) {
                        if (!methodMatcher.matches(type)) continue;
                        acc.set(true);
                    }
                }
                return tree;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(AtomicBoolean acc) {
        if (acc.get()) {
            return new AddDependency("org.hamcrest", "hamcrest-junit", "2.x", null, null, null, null, null, null, "test", null, null, null, Boolean.valueOf(true)).getVisitor();
        }
        return TreeVisitor.noop();
    }
}

