/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.DeclaresMethod;
import org.openrewrite.java.tree.J;

public class NoFinalizer
extends Recipe {
    private static final MethodMatcher FINALIZER = new MethodMatcher("java.lang.Object finalize()", true);

    public String getDisplayName() {
        return "Remove `finalize()` method";
    }

    public String getDescription() {
        return "Finalizers are deprecated. Use of `finalize()` can lead to performance issues, deadlocks, hangs, and other undesirable behavior.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S1111");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(20L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new DeclaresMethod(FINALIZER), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                cd = cd.withBody(cd.getBody().withStatements(ListUtils.map((List)cd.getBody().getStatements(), stmt -> {
                    if (stmt instanceof J.MethodDeclaration && FINALIZER.matches((J.MethodDeclaration)stmt, classDecl)) {
                        return null;
                    }
                    return stmt;
                })));
                return cd;
            }
        });
    }
}

