/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.javax;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public final class AddTransientAnnotationToPrivateAccessor
extends Recipe {
    public String getDisplayName() {
        return "Private accessor methods must have a `@Transient` annotation";
    }

    public String getDescription() {
        return "According to the JPA 2.1 specification, when property access is used, the property accessor methods must be public or protected. OpenJPA ignores any private accessor methods, whereas EclipseLink persists those attributes. To ignore private accessor methods in EclipseLink, the methods must have a `@Transient` annotation.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("javax.persistence.Entity", Boolean.valueOf(true)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            List<JavaType.Variable> classVars = new ArrayList<JavaType.Variable>();

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                this.classVars = classDecl.getBody().getStatements().stream().filter(J.VariableDeclarations.class::isInstance).map(J.VariableDeclarations.class::cast).map(J.VariableDeclarations::getVariables).flatMap(Collection::stream).map(var -> var.getName().getFieldType()).filter(Objects::nonNull).collect(Collectors.toList());
                return super.visitClassDeclaration(classDecl, (Object)ctx);
            }

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration md, ExecutionContext ctx) {
                if (this.isPrivateAccessorMethodWithoutTransientAnnotation(md)) {
                    this.maybeAddImport("javax.persistence.Transient");
                    return (J.MethodDeclaration)JavaTemplate.builder((String)"@Transient").contextSensitive().javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"javax.persistence-api-2.2"})).imports(new String[]{"javax.persistence.Transient"}).build().apply(this.getCursor(), md.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
                }
                return md;
            }

            private boolean isPrivateAccessorMethodWithoutTransientAnnotation(J.MethodDeclaration method) {
                return method.hasModifier(J.Modifier.Type.Private) && method.getParameters().get(0) instanceof J.Empty && method.getReturnTypeExpression().getType() != JavaType.Primitive.Void && FindAnnotations.find((J)method, (String)"javax.persistence.Transient").isEmpty() && this.methodReturnsFieldFromClass(method);
            }

            private boolean methodReturnsFieldFromClass(J.MethodDeclaration method) {
                ArrayList returns = new ArrayList();
                JavaIsoVisitor<List<JavaType.Variable>> returnValueCollector = new JavaIsoVisitor<List<JavaType.Variable>>(){

                    public J.Return visitReturn(J.Return ret, List<JavaType.Variable> returnedVars) {
                        Expression expression = ret.getExpression();
                        if (expression instanceof J.FieldAccess) {
                            JavaType.Variable returnedVar = ((J.FieldAccess)expression).getName().getFieldType();
                            returnedVars.add(returnedVar);
                        } else if (expression instanceof J.Identifier) {
                            JavaType.Variable returnedVar = ((J.Identifier)expression).getFieldType();
                            returnedVars.add(returnedVar);
                        }
                        return super.visitReturn(ret, returnedVars);
                    }
                };
                returnValueCollector.visitBlock(method.getBody(), returns);
                return returns.stream().anyMatch(this.classVars::contains);
            }
        });
    }

    @Generated
    public AddTransientAnnotationToPrivateAccessor() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddTransientAnnotationToPrivateAccessor()";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddTransientAnnotationToPrivateAccessor)) {
            return false;
        }
        AddTransientAnnotationToPrivateAccessor other = (AddTransientAnnotationToPrivateAccessor)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddTransientAnnotationToPrivateAccessor;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

