/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.table;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public class JavaVersionMigrationPlan
extends DataTable<Row> {
    public JavaVersionMigrationPlan(Recipe recipe) {
        super(recipe, "Java version migration plan", "A per-repository view of the current state of Java versions and associated build tools");
    }

    public static final class Row {
        @Column(displayName="Has Java", description="Whether this is a Java repository at all.")
        private final boolean hasJava;
        @Column(displayName="Source compatibility", description="The source compatibility of the source file.")
        private final String sourceCompatibility;
        @Column(displayName="Major version source compatibility", description="The major version.")
        private final Integer majorVersionSourceCompatibility;
        @Column(displayName="Target compatibility", description="The target compatibility or `--release` version of the source file.")
        private final String targetCompatibility;
        @Column(displayName="Gradle version", description="The version of Gradle in use, if any.")
        private final String gradleVersion;
        @Column(displayName="Has Gradle build", description="Whether a build.gradle file exists in the repository.")
        private final Boolean hasGradleBuild;
        @Column(displayName="Maven version", description="The version of Maven in use, if any.")
        private final String mavenVersion;
        @Column(displayName="Has Maven pom", description="Whether a pom.xml file exists in the repository.")
        private final Boolean hasMavenPom;

        @ConstructorProperties(value={"hasJava", "sourceCompatibility", "majorVersionSourceCompatibility", "targetCompatibility", "gradleVersion", "hasGradleBuild", "mavenVersion", "hasMavenPom"})
        @Generated
        Row(boolean hasJava, String sourceCompatibility, Integer majorVersionSourceCompatibility, String targetCompatibility, String gradleVersion, Boolean hasGradleBuild, String mavenVersion, Boolean hasMavenPom) {
            this.hasJava = hasJava;
            this.sourceCompatibility = sourceCompatibility;
            this.majorVersionSourceCompatibility = majorVersionSourceCompatibility;
            this.targetCompatibility = targetCompatibility;
            this.gradleVersion = gradleVersion;
            this.hasGradleBuild = hasGradleBuild;
            this.mavenVersion = mavenVersion;
            this.hasMavenPom = hasMavenPom;
        }

        @NonNull
        @Generated
        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public boolean isHasJava() {
            return this.hasJava;
        }

        @Generated
        public String getSourceCompatibility() {
            return this.sourceCompatibility;
        }

        @Generated
        public Integer getMajorVersionSourceCompatibility() {
            return this.majorVersionSourceCompatibility;
        }

        @Generated
        public String getTargetCompatibility() {
            return this.targetCompatibility;
        }

        @Generated
        public String getGradleVersion() {
            return this.gradleVersion;
        }

        @Generated
        public Boolean getHasGradleBuild() {
            return this.hasGradleBuild;
        }

        @Generated
        public String getMavenVersion() {
            return this.mavenVersion;
        }

        @Generated
        public Boolean getHasMavenPom() {
            return this.hasMavenPom;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            if (this.isHasJava() != other.isHasJava()) {
                return false;
            }
            Integer this$majorVersionSourceCompatibility = this.getMajorVersionSourceCompatibility();
            Integer other$majorVersionSourceCompatibility = other.getMajorVersionSourceCompatibility();
            if (this$majorVersionSourceCompatibility == null ? other$majorVersionSourceCompatibility != null : !((Object)this$majorVersionSourceCompatibility).equals(other$majorVersionSourceCompatibility)) {
                return false;
            }
            Boolean this$hasGradleBuild = this.getHasGradleBuild();
            Boolean other$hasGradleBuild = other.getHasGradleBuild();
            if (this$hasGradleBuild == null ? other$hasGradleBuild != null : !((Object)this$hasGradleBuild).equals(other$hasGradleBuild)) {
                return false;
            }
            Boolean this$hasMavenPom = this.getHasMavenPom();
            Boolean other$hasMavenPom = other.getHasMavenPom();
            if (this$hasMavenPom == null ? other$hasMavenPom != null : !((Object)this$hasMavenPom).equals(other$hasMavenPom)) {
                return false;
            }
            String this$sourceCompatibility = this.getSourceCompatibility();
            String other$sourceCompatibility = other.getSourceCompatibility();
            if (this$sourceCompatibility == null ? other$sourceCompatibility != null : !this$sourceCompatibility.equals(other$sourceCompatibility)) {
                return false;
            }
            String this$targetCompatibility = this.getTargetCompatibility();
            String other$targetCompatibility = other.getTargetCompatibility();
            if (this$targetCompatibility == null ? other$targetCompatibility != null : !this$targetCompatibility.equals(other$targetCompatibility)) {
                return false;
            }
            String this$gradleVersion = this.getGradleVersion();
            String other$gradleVersion = other.getGradleVersion();
            if (this$gradleVersion == null ? other$gradleVersion != null : !this$gradleVersion.equals(other$gradleVersion)) {
                return false;
            }
            String this$mavenVersion = this.getMavenVersion();
            String other$mavenVersion = other.getMavenVersion();
            return !(this$mavenVersion == null ? other$mavenVersion != null : !this$mavenVersion.equals(other$mavenVersion));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isHasJava() ? 79 : 97);
            Integer $majorVersionSourceCompatibility = this.getMajorVersionSourceCompatibility();
            result = result * 59 + ($majorVersionSourceCompatibility == null ? 43 : ((Object)$majorVersionSourceCompatibility).hashCode());
            Boolean $hasGradleBuild = this.getHasGradleBuild();
            result = result * 59 + ($hasGradleBuild == null ? 43 : ((Object)$hasGradleBuild).hashCode());
            Boolean $hasMavenPom = this.getHasMavenPom();
            result = result * 59 + ($hasMavenPom == null ? 43 : ((Object)$hasMavenPom).hashCode());
            String $sourceCompatibility = this.getSourceCompatibility();
            result = result * 59 + ($sourceCompatibility == null ? 43 : $sourceCompatibility.hashCode());
            String $targetCompatibility = this.getTargetCompatibility();
            result = result * 59 + ($targetCompatibility == null ? 43 : $targetCompatibility.hashCode());
            String $gradleVersion = this.getGradleVersion();
            result = result * 59 + ($gradleVersion == null ? 43 : $gradleVersion.hashCode());
            String $mavenVersion = this.getMavenVersion();
            result = result * 59 + ($mavenVersion == null ? 43 : $mavenVersion.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "JavaVersionMigrationPlan.Row(hasJava=" + this.isHasJava() + ", sourceCompatibility=" + this.getSourceCompatibility() + ", majorVersionSourceCompatibility=" + this.getMajorVersionSourceCompatibility() + ", targetCompatibility=" + this.getTargetCompatibility() + ", gradleVersion=" + this.getGradleVersion() + ", hasGradleBuild=" + this.getHasGradleBuild() + ", mavenVersion=" + this.getMavenVersion() + ", hasMavenPom=" + this.getHasMavenPom() + ")";
        }

        @Generated
        public static class Builder {
            @Generated
            private boolean hasJava;
            @Generated
            private String sourceCompatibility;
            @Generated
            private Integer majorVersionSourceCompatibility;
            @Generated
            private String targetCompatibility;
            @Generated
            private String gradleVersion;
            @Generated
            private Boolean hasGradleBuild;
            @Generated
            private String mavenVersion;
            @Generated
            private Boolean hasMavenPom;

            @Generated
            Builder() {
            }

            @NonNull
            @Generated
            public Builder hasJava(boolean hasJava) {
                this.hasJava = hasJava;
                return this;
            }

            @NonNull
            @Generated
            public Builder sourceCompatibility(String sourceCompatibility) {
                this.sourceCompatibility = sourceCompatibility;
                return this;
            }

            @NonNull
            @Generated
            public Builder majorVersionSourceCompatibility(Integer majorVersionSourceCompatibility) {
                this.majorVersionSourceCompatibility = majorVersionSourceCompatibility;
                return this;
            }

            @NonNull
            @Generated
            public Builder targetCompatibility(String targetCompatibility) {
                this.targetCompatibility = targetCompatibility;
                return this;
            }

            @NonNull
            @Generated
            public Builder gradleVersion(String gradleVersion) {
                this.gradleVersion = gradleVersion;
                return this;
            }

            @NonNull
            @Generated
            public Builder hasGradleBuild(Boolean hasGradleBuild) {
                this.hasGradleBuild = hasGradleBuild;
                return this;
            }

            @NonNull
            @Generated
            public Builder mavenVersion(String mavenVersion) {
                this.mavenVersion = mavenVersion;
                return this;
            }

            @NonNull
            @Generated
            public Builder hasMavenPom(Boolean hasMavenPom) {
                this.hasMavenPom = hasMavenPom;
                return this;
            }

            @NonNull
            @Generated
            public Row build() {
                return new Row(this.hasJava, this.sourceCompatibility, this.majorVersionSourceCompatibility, this.targetCompatibility, this.gradleVersion, this.hasGradleBuild, this.mavenVersion, this.hasMavenPom);
            }

            @NonNull
            @Generated
            public String toString() {
                return "JavaVersionMigrationPlan.Row.Builder(hasJava=" + this.hasJava + ", sourceCompatibility=" + this.sourceCompatibility + ", majorVersionSourceCompatibility=" + this.majorVersionSourceCompatibility + ", targetCompatibility=" + this.targetCompatibility + ", gradleVersion=" + this.gradleVersion + ", hasGradleBuild=" + this.hasGradleBuild + ", mavenVersion=" + this.mavenVersion + ", hasMavenPom=" + this.hasMavenPom + ")";
            }
        }
    }
}

