/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.apache.commons.lang;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.migrate.apache.commons.lang.RepeatableArgumentMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.template.Semantics;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.staticanalysis.UnnecessaryParentheses;

public class IsNotEmptyToJdk
extends Recipe {
    public String getDisplayName() {
        return "Replace any StringUtils#isEmpty(String) and #isNotEmpty(String)";
    }

    public String getDescription() {
        return "Replace any `StringUtils#isEmpty(String)` and `#isNotEmpty(String)` with `s == null || s.isEmpty()` and `s != null && !s.isEmpty()`.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public Set<String> getTags() {
        return new HashSet<String>(Arrays.asList("apache", "commons"));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor precondition = Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.apache.commons.lang3.StringUtils isEmpty(..)"), new UsesMethod("org.apache.commons.lang3.StringUtils isNotEmpty(..)"), new UsesMethod("org.apache.maven.shared.utils.StringUtils isEmpty(..)"), new UsesMethod("org.apache.maven.shared.utils.StringUtils isNotEmpty(..)"), new UsesMethod("org.codehaus.plexus.util.StringUtils isEmpty(..)"), new UsesMethod("org.codehaus.plexus.util.StringUtils isNotEmpty(..)")});
        return Preconditions.check((TreeVisitor)precondition, (TreeVisitor)new JavaVisitor<ExecutionContext>(){
            private final MethodMatcher isEmptyMatcher = new MethodMatcher("*..StringUtils isEmpty(..)");
            private final MethodMatcher isNotEmptyMatcher = new MethodMatcher("*..StringUtils isNotEmpty(..)");
            private final MethodMatcher trimMatcher = new MethodMatcher("java.lang.String trim()");
            private final JavaTemplate isEmptyReplacement = Semantics.expression((JavaVisitor)this, (String)"IsEmpty", s -> s == null || s.isEmpty()).build();
            private final JavaTemplate isNotEmptyReplacement = Semantics.expression((JavaVisitor)this, (String)"IsNotEmpty", s -> s != null && !s.isEmpty()).build();
            private final JavaTemplate isEmptyTrimmed = Semantics.expression((JavaVisitor)this, (String)"IsEmptyTrimmed", s -> s.trim().isEmpty()).build();
            private final JavaTemplate isNotEmptyTrimmed = Semantics.expression((JavaVisitor)this, (String)"IsNotEmptyTrimmed", s -> !s.trim().isEmpty()).build();

            public J visitMethodInvocation(J.MethodInvocation mi, ExecutionContext ctx) {
                boolean isEmptyCall = this.isEmptyMatcher.matches((MethodCall)mi);
                if (!isEmptyCall && !this.isNotEmptyMatcher.matches((MethodCall)mi)) {
                    return mi;
                }
                Expression arg = (Expression)mi.getArguments().get(0);
                if (RepeatableArgumentMatcher.isRepeatableArgument(arg)) {
                    JavaTemplate replacementTemplate = isEmptyCall ? this.isEmptyReplacement : this.isNotEmptyReplacement;
                    this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                    this.maybeRemoveImport("org.apache.maven.shared.utils.StringUtils");
                    this.maybeRemoveImport("org.codehaus.plexus.util.StringUtils");
                    this.doAfterVisit(new UnnecessaryParentheses().getVisitor());
                    return replacementTemplate.apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), new Object[]{arg});
                }
                if (this.trimMatcher.matches(arg) && (((J.MethodInvocation)arg).getSelect() instanceof J.Identifier || ((J.MethodInvocation)arg).getSelect() instanceof J.FieldAccess)) {
                    JavaTemplate replacementTemplate = isEmptyCall ? this.isEmptyTrimmed : this.isNotEmptyTrimmed;
                    this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                    this.maybeRemoveImport("org.apache.maven.shared.utils.StringUtils");
                    this.maybeRemoveImport("org.codehaus.plexus.util.StringUtils");
                    return replacementTemplate.apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), new Object[]{((J.MethodInvocation)arg).getSelect()});
                }
                return super.visitMethodInvocation(mi, (Object)ctx);
            }
        });
    }
}

