/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.apache.commons.lang;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.migrate.apache.commons.lang.RepeatableArgumentMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.Semantics;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class ApacheCommonsStringUtilsRecipes
extends Recipe {
    public String getDisplayName() {
        return "`ApacheCommonsStringUtils` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `org.openrewrite.java.migrate.apache.commons.lang.ApacheCommonsStringUtils`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AbbreviateRecipe(), new CapitalizeRecipe(), new DefaultStringRecipe(), new DefaultStringFallbackRecipe(), new DeleteWhitespaceRecipe(), new EqualsIgnoreCaseRecipe(), new EqualsRecipe(), new LowercaseRecipe(), new RemoveEndRecipe(), new ReplaceRecipe(), new ReverseRecipe(), new SplitRecipe(), new StripRecipe(), new TrimToEmptyRecipe(), new TrimToNullRecipe(), new TrimRecipe(), new UppercaseRecipe()});
    }

    @NonNullApi
    public static class AbbreviateRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.abbreviate(String, int)` with JDK internals";
        }

        public String getDescription() {
            return "Replace Apache Commons `StringUtils.abbreviate(String str, int maxWidth)` with JDK internals.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (s1, width) -> StringUtils.abbreviate((String)s1, (int)width)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (s, width) -> s == null || s.length() <= width ? s : s.substring(0, width - 3) + "...").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(1))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.REMOVE_PARENS, AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.lang3.StringUtils abbreviate(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class CapitalizeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.capitalize(String)` with JDK internals";
        }

        public String getDescription() {
            return "Replace Apache Commons `StringUtils.capitalize(String str)` with JDK internals.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", s -> StringUtils.capitalize((String)s)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", s -> s == null || s.isEmpty() || Character.isTitleCase(s.charAt(0)) ? s : Character.toTitleCase(s.charAt(0)) + s.substring(1)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.REMOVE_PARENS, AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.lang3.StringUtils capitalize(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class DefaultStringRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.defaultString(String)` with JDK internals";
        }

        public String getDescription() {
            return "Replace Apache Commons `StringUtils.defaultString(String str)` with JDK internals.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", s -> StringUtils.defaultString((String)s)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", s -> Objects.toString(s, "")).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.lang3.StringUtils defaultString(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class DefaultStringFallbackRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.defaultString(String, String)` with JDK internals";
        }

        public String getDescription() {
            return "Replace Apache Commons `StringUtils.defaultString(String str, String nullDefault)` with JDK internals.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (s, nullDefault) -> StringUtils.defaultString((String)s, (String)nullDefault)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (s, nullDefault) -> Objects.toString(s, nullDefault)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.lang3.StringUtils defaultString(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class DeleteWhitespaceRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.deleteWhitespace(String)` with JDK internals";
        }

        public String getDescription() {
            return "Replace Apache Commons `StringUtils.deleteWhitespace(String str)` with JDK internals.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", s -> StringUtils.deleteWhitespace((String)s)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", s -> s == null ? null : s.replaceAll("\\s+", "")).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.REMOVE_PARENS, AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.lang3.StringUtils deleteWhitespace(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class EqualsIgnoreCaseRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.equalsIgnoreCase(CharSequence, CharSequence)` with JDK internals";
        }

        public String getDescription() {
            return "Replace Apache Commons `StringUtils.equalsIgnoreCase(CharSequence cs1, CharSequence cs2)` with JDK internals.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (s, other) -> StringUtils.equalsIgnoreCase((CharSequence)s, (CharSequence)other)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (s, other) -> s == null ? other == null : s.equalsIgnoreCase((String)other)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(1))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.REMOVE_PARENS, AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.lang3.StringUtils equalsIgnoreCase(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class EqualsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.equals(CharSequence, CharSequence)` with JDK internals";
        }

        public String getDescription() {
            return "Replace Apache Commons `StringUtils.equals(CharSequence cs1, CharSequence cs2)` with JDK internals.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (s, other) -> StringUtils.equals((CharSequence)s, (CharSequence)other)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (s, other) -> Objects.equals(s, other)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.lang3.StringUtils equals(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LowercaseRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.lowerCase(String)` with JDK internals";
        }

        public String getDescription() {
            return "Replace Apache Commons `StringUtils.lowerCase(String str)` with JDK internals.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", s -> StringUtils.lowerCase((String)s)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", s -> s == null ? null : s.toLowerCase()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.REMOVE_PARENS, AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.lang3.StringUtils lowerCase(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class RemoveEndRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.removeEnd(String, String)` with JDK internals";
        }

        public String getDescription() {
            return "Replace Apache Commons `StringUtils.removeEnd(String str, String remove)` with JDK internals.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (s, end) -> StringUtils.removeEnd((String)s, (String)end)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (s, end) -> s == null || s.isEmpty() || end == null || end.isEmpty() || !s.endsWith((String)end) ? s : s.substring(0, s.length() - end.length())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(1))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.REMOVE_PARENS, AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.lang3.StringUtils removeEnd(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class ReplaceRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.replace(String, String, String)` with JDK internals";
        }

        public String getDescription() {
            return "Replace Apache Commons `StringUtils.replace(String text, String searchString, String replacement)` with JDK internals.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (s, search, replacement) -> StringUtils.replace((String)s, (String)search, (String)replacement)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (s, search, replacement) -> s == null || s.isEmpty() || search == null || search.isEmpty() || replacement == null ? s : s.replace((CharSequence)search, (CharSequence)replacement)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(1))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(2))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.REMOVE_PARENS, AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.lang3.StringUtils replace(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class ReverseRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.reverse(String)` with JDK internals";
        }

        public String getDescription() {
            return "Replace Apache Commons `StringUtils.reverse(String str)` with JDK internals.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", s -> StringUtils.reverse((String)s)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", s -> s == null ? null : new StringBuilder((String)s).reverse().toString()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.REMOVE_PARENS, AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.lang3.StringUtils reverse(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class SplitRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.split(String)` with JDK internals";
        }

        public String getDescription() {
            return "Replace Apache Commons `StringUtils.split(String str)` with JDK internals.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", s -> StringUtils.split((String)s)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", s -> s == null ? null : s.split("\\s+")).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.REMOVE_PARENS, AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.lang3.StringUtils split(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class StripRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.strip(String)` with JDK internals";
        }

        public String getDescription() {
            return "Replace Apache Commons `StringUtils.strip(String str)` with JDK internals.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", s -> StringUtils.strip((String)s)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", s -> s == null ? null : s.trim()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.REMOVE_PARENS, AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.lang3.StringUtils strip(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class TrimToEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.trimToEmpty(String)` with JDK internals";
        }

        public String getDescription() {
            return "Replace Apache Commons `StringUtils.trimToEmpty(String str)` with JDK internals.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", s -> StringUtils.trimToEmpty((String)s)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", s -> s == null ? "" : s.trim()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.REMOVE_PARENS, AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.lang3.StringUtils trimToEmpty(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class TrimToNullRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.trimToNull(String)` with JDK internals";
        }

        public String getDescription() {
            return "Replace Apache Commons `StringUtils.trimToNull(String str)` with JDK internals.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", s -> StringUtils.trimToNull((String)s)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", s -> s == null || s.trim().isEmpty() ? null : s.trim()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.REMOVE_PARENS, AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.lang3.StringUtils trimToNull(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class TrimRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.trim(String)` with JDK internals";
        }

        public String getDescription() {
            return "Replace Apache Commons `StringUtils.trim(String str)` with JDK internals.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", s -> StringUtils.trim((String)s)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", s -> s == null ? null : s.trim()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.REMOVE_PARENS, AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.lang3.StringUtils trim(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class UppercaseRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.upperCase(String)` with JDK internals";
        }

        public String getDescription() {
            return "Replace Apache Commons `StringUtils.upperCase(String str)` with JDK internals.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", s -> StringUtils.upperCase((String)s)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", s -> s == null ? null : s.toUpperCase()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.REMOVE_PARENS, AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.lang3.StringUtils upperCase(..)")}), (TreeVisitor)javaVisitor);
        }
    }
}

