/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public class CastArraysAsListToList
extends Recipe {
    private static final MethodMatcher ARRAYS_AS_LIST = new MethodMatcher("java.util.Arrays asList(..)", false);
    private static final MethodMatcher LIST_TO_ARRAY = new MethodMatcher("java.util.List toArray()", true);

    public String getDisplayName() {
        return "Remove explicit casts on `Arrays.asList(..).toArray()`";
    }

    public String getDescription() {
        return "Convert code like `(Integer[]) Arrays.asList(1, 2, 3).toArray()` to `Arrays.asList(1, 2, 3).toArray(new Integer[0])`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod(ARRAYS_AS_LIST), new UsesMethod(LIST_TO_ARRAY)}), (TreeVisitor)new CastArraysAsListToListVisitor());
    }

    private static class CastArraysAsListToListVisitor
    extends JavaVisitor<ExecutionContext> {
        private CastArraysAsListToListVisitor() {
        }

        public J visitTypeCast(J.TypeCast typeCast, ExecutionContext executionContext) {
            boolean matches;
            J j = super.visitTypeCast(typeCast, (Object)executionContext);
            if (!(j instanceof J.TypeCast)) {
                return j;
            }
            typeCast = (J.TypeCast)j;
            boolean bl = matches = typeCast.getClazz().getTree() instanceof J.ArrayType && (typeCast.getType() instanceof JavaType.Class || typeCast.getType() instanceof JavaType.Parameterized) && ((JavaType.FullyQualified)typeCast.getType()).getOwningClass() == null && LIST_TO_ARRAY.matches(typeCast.getExpression()) && typeCast.getExpression() instanceof J.MethodInvocation && ARRAYS_AS_LIST.matches(((J.MethodInvocation)typeCast.getExpression()).getSelect());
            if (!matches) {
                return typeCast;
            }
            String fullyQualifiedName = ((JavaType.FullyQualified)typeCast.getType()).getFullyQualifiedName();
            int dimensionSize = ((J.ArrayType)typeCast.getClazz().getTree()).getDimensions().size();
            if (fullyQualifiedName.equals("java.lang.Object") && dimensionSize == 1) {
                return typeCast;
            }
            StringBuilder newArrayString = new StringBuilder();
            String className = fullyQualifiedName.substring(fullyQualifiedName.lastIndexOf(".") + 1);
            newArrayString.append(className);
            newArrayString.append("[0]");
            for (int i = 0; i < dimensionSize - 1; ++i) {
                newArrayString.append("[]");
            }
            JavaTemplate t = JavaTemplate.builder((String)("#{any(java.util.List)}.toArray(new " + newArrayString + ")")).imports(new String[]{fullyQualifiedName}).build();
            return t.apply(this.updateCursor((Tree)typeCast), typeCast.getCoordinates().replace(), new Object[]{((J.MethodInvocation)typeCast.getExpression()).getSelect()});
        }
    }
}

