/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.liberty;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class RemoveWas2LibertyNonPortableJndiLookup
extends Recipe {
    public String getDisplayName() {
        return "Removes invalid JNDI properties";
    }

    public String getDescription() {
        return "Remove the use of invalid JNDI properties from Hashtable.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MethodInvocationVisitor();
    }

    private class MethodInvocationVisitor
    extends JavaVisitor<ExecutionContext> {
        MethodMatcher methodMatcher = new MethodMatcher("java.util.Hashtable put(java.lang.Object, java.lang.Object)", false);

        private MethodInvocationVisitor() {
        }

        @Nullable
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ec) {
            return this.visitMethodCall(method);
        }

        @Nullable
        private <M extends MethodCall> M visitMethodCall(M methodCall) {
            if (!this.methodMatcher.matches(methodCall)) {
                return methodCall;
            }
            J.Block parentBlock = (J.Block)this.getCursor().firstEnclosing(J.Block.class);
            if (parentBlock != null && !parentBlock.getStatements().contains(methodCall)) {
                return methodCall;
            }
            Expression firstArg = (Expression)methodCall.getArguments().get(0);
            if (firstArg instanceof J.Literal) {
                J.Literal literalExp = (J.Literal)firstArg;
                Object value = literalExp.getValue();
                if (!value.equals("java.naming.factory.initial") && !value.equals("java.naming.provider.url")) {
                    return methodCall;
                }
            } else {
                return methodCall;
            }
            if (methodCall.getMethodType() != null) {
                this.maybeRemoveImport(methodCall.getMethodType().getDeclaringType());
            }
            return null;
        }
    }
}

