/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openrewrite.java.dependencies.internal.Version;

public class VersionParser {
    private final Map<String, Version> cache = new ConcurrentHashMap<String, Version>();

    public Version transform(String original) {
        return this.cache.computeIfAbsent(original, this::parse);
    }

    private Version parse(String original) {
        int pos;
        ArrayList<String> parts = new ArrayList<String>();
        boolean digit = false;
        int startPart = 0;
        int endBaseStr = 0;
        for (pos = 0; pos < original.length(); ++pos) {
            char ch = original.charAt(pos);
            if (ch == '.' || ch == '_' || ch == '-' || ch == '+') {
                parts.add(original.substring(startPart, pos));
                startPart = pos + 1;
                digit = false;
                if (ch == '.' || endBaseStr != 0) continue;
                endBaseStr = pos;
                continue;
            }
            if (ch >= '0' && ch <= '9') {
                if (!digit && pos > startPart) {
                    if (endBaseStr == 0) {
                        endBaseStr = pos;
                    }
                    parts.add(original.substring(startPart, pos));
                    startPart = pos;
                }
                digit = true;
                continue;
            }
            if (digit) {
                if (endBaseStr == 0) {
                    endBaseStr = pos;
                }
                parts.add(original.substring(startPart, pos));
                startPart = pos;
            }
            digit = false;
        }
        if (pos > startPart) {
            parts.add(original.substring(startPart, pos));
        }
        return new DefaultVersion(original, parts);
    }

    private static class DefaultVersion
    implements Version {
        private final String source;
        private final String[] parts;
        private final Long[] numericParts;

        public DefaultVersion(String source, List<String> parts) {
            this.source = source;
            this.parts = parts.toArray(new String[0]);
            this.numericParts = new Long[this.parts.length];
            for (int i = 0; i < parts.size(); ++i) {
                try {
                    this.numericParts[i] = Long.parseLong(this.parts[i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        public String toString() {
            return this.source;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            DefaultVersion other = (DefaultVersion)obj;
            return this.source.equals(other.source);
        }

        public int hashCode() {
            return this.source.hashCode();
        }

        @Override
        public String[] getParts() {
            return this.parts;
        }

        @Override
        public Long[] getNumericParts() {
            return this.numericParts;
        }

        @Override
        public String getSource() {
            return this.source;
        }
    }
}

