/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.maven.table.DependenciesInUse;

public final class DependencyInsight
extends Recipe {
    private final transient DependenciesInUse dependenciesInUse = new DependenciesInUse((Recipe)this);
    @Option(displayName="Group pattern", description="Group ID glob pattern used to match dependencies.", example="com.fasterxml.jackson*")
    private final String groupIdPattern;
    @Option(displayName="Artifact pattern", description="Artifact ID glob pattern used to match dependencies.", example="jackson-*")
    private final String artifactIdPattern;
    @Option(displayName="Version", description="Match only dependencies with the specified version. Node-style [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors) may be used. All versions are searched by default.", example="1.x", required=false)
    private final @Nullable String version;
    @Option(displayName="Scope", description="Match dependencies with the specified Maven scope. All scopes are searched by default.", valid={"compile", "test", "runtime", "provided", "system"}, example="compile", required=false)
    private final @Nullable String scope;

    public String getDisplayName() {
        return "Dependency insight for Gradle and Maven";
    }

    public String getDescription() {
        return "Finds dependencies, including transitive dependencies, in both Gradle and Maven projects. Matches within all Gradle dependency configurations and Maven scopes.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){
            final TreeVisitor<?, ExecutionContext> gdi;
            final TreeVisitor<?, ExecutionContext> mdi;
            {
                this.gdi = new org.openrewrite.gradle.search.DependencyInsight(DependencyInsight.this.groupIdPattern, DependencyInsight.this.artifactIdPattern, DependencyInsight.this.version, null).getVisitor();
                this.mdi = new org.openrewrite.maven.search.DependencyInsight(DependencyInsight.this.groupIdPattern, DependencyInsight.this.artifactIdPattern, DependencyInsight.this.scope, DependencyInsight.this.version, Boolean.valueOf(false)).getVisitor();
            }

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (!(tree instanceof SourceFile)) {
                    return tree;
                }
                SourceFile s = (SourceFile)tree;
                if (this.gdi.isAcceptable(s, (Object)ctx)) {
                    s = (SourceFile)this.gdi.visitNonNull((Tree)s, (Object)ctx);
                } else if (this.mdi.isAcceptable(s, (Object)ctx)) {
                    s = (SourceFile)this.mdi.visitNonNull((Tree)s, (Object)ctx);
                }
                return s;
            }
        };
    }

    @ConstructorProperties(value={"groupIdPattern", "artifactIdPattern", "version", "scope"})
    @Generated
    public DependencyInsight(String groupIdPattern, String artifactIdPattern, @Nullable String version, @Nullable String scope) {
        this.groupIdPattern = groupIdPattern;
        this.artifactIdPattern = artifactIdPattern;
        this.version = version;
        this.scope = scope;
    }

    @Generated
    public DependenciesInUse getDependenciesInUse() {
        return this.dependenciesInUse;
    }

    @Generated
    public String getGroupIdPattern() {
        return this.groupIdPattern;
    }

    @Generated
    public String getArtifactIdPattern() {
        return this.artifactIdPattern;
    }

    @Generated
    public @Nullable String getVersion() {
        return this.version;
    }

    @Generated
    public @Nullable String getScope() {
        return this.scope;
    }

    @Generated
    public String toString() {
        return "DependencyInsight(dependenciesInUse=" + this.getDependenciesInUse() + ", groupIdPattern=" + this.getGroupIdPattern() + ", artifactIdPattern=" + this.getArtifactIdPattern() + ", version=" + this.getVersion() + ", scope=" + this.getScope() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DependencyInsight)) {
            return false;
        }
        DependencyInsight other = (DependencyInsight)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupIdPattern = this.getGroupIdPattern();
        String other$groupIdPattern = other.getGroupIdPattern();
        if (this$groupIdPattern == null ? other$groupIdPattern != null : !this$groupIdPattern.equals(other$groupIdPattern)) {
            return false;
        }
        String this$artifactIdPattern = this.getArtifactIdPattern();
        String other$artifactIdPattern = other.getArtifactIdPattern();
        if (this$artifactIdPattern == null ? other$artifactIdPattern != null : !this$artifactIdPattern.equals(other$artifactIdPattern)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        return !(this$scope == null ? other$scope != null : !this$scope.equals(other$scope));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DependencyInsight;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupIdPattern = this.getGroupIdPattern();
        result = result * 59 + ($groupIdPattern == null ? 43 : $groupIdPattern.hashCode());
        String $artifactIdPattern = this.getArtifactIdPattern();
        result = result * 59 + ($artifactIdPattern == null ? 43 : $artifactIdPattern.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        return result;
    }
}

