/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies.github;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.csv.CsvFactory;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.List;
import org.openrewrite.java.dependencies.Vulnerability;
import org.openrewrite.java.dependencies.github.advisories.Advisory;
import org.openrewrite.java.dependencies.github.advisories.Affected;
import org.openrewrite.java.dependencies.github.advisories.Range;

public class ParseAdvisories {
    public static void main(String[] args) throws IOException {
        File advisoriesRepo;
        if (args.length != 3) {
            System.err.println("Usage: ParseAdvisories <advisories-repo> <ecosystem> <advisories-csv>");
            System.exit(1);
        }
        if (!(advisoriesRepo = new File(args[0])).isDirectory() || !advisoriesRepo.canRead()) {
            System.err.println("Advisories repo " + advisoriesRepo + " not readable");
            System.exit(1);
        }
        String ecosystem = args[1];
        File advisoriesCsv = new File(args[2]);
        if (!advisoriesCsv.createNewFile() && !advisoriesCsv.canWrite()) {
            System.err.println("Advisories CSV " + advisoriesCsv + " not writable");
            System.exit(1);
        }
        ParseAdvisories.parseAdvisories(advisoriesRepo, ecosystem, advisoriesCsv);
    }

    static void parseAdvisories(File advisoriesRepoInput, String ecosystem, File advisoriesCsvOutput) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(advisoriesCsvOutput);){
            Files.walkFileTree(advisoriesRepoInput.toPath(), Collections.emptySet(), 16, new MavenAdvisoriesVisitor(ecosystem, fos));
        }
    }

    private static final class MavenAdvisoriesVisitor
    extends SimpleFileVisitor<Path> {
        private final String ecosystem;
        private final FileOutputStream fos;
        private final ObjectMapper reader;
        private final ObjectWriter writer;
        private Path current;

        public MavenAdvisoriesVisitor(String ecosystem, FileOutputStream fos) {
            this.ecosystem = ecosystem;
            this.fos = fos;
            this.reader = MavenAdvisoriesVisitor.getObjectMapper();
            this.writer = MavenAdvisoriesVisitor.getObjectWriter();
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
            if (path.getFileName().toString().endsWith(".json")) {
                Path parent = path.getParent().getParent();
                if (this.current == null || !this.current.equals(parent)) {
                    this.current = parent;
                    System.out.println("Parsing " + this.current);
                }
                Advisory advisory = (Advisory)this.reader.readValue(path.toFile(), Advisory.class);
                for (Affected affected : advisory.getAffected()) {
                    if (!affected.getPkg().getEcosystem().equalsIgnoreCase(this.ecosystem) || affected.getRanges() == null || affected.getRanges().isEmpty()) continue;
                    Range range = affected.getRanges().iterator().next();
                    String cve = advisory.getAliases().isEmpty() ? advisory.getId() : advisory.getAliases().iterator().next();
                    List<String> cweIds = advisory.getDatabaseSpecific().getCweIds();
                    String cwes = cweIds == null || cweIds.isEmpty() ? null : String.join((CharSequence)";", cweIds);
                    Vulnerability vulnerability = new Vulnerability(cve, advisory.getPublished(), advisory.getSummary(), affected.getPkg().getName(), range.getIntroduced(), range.getFixed(), Vulnerability.Severity.valueOf(advisory.getDatabaseSpecific().getSeverity()), cwes);
                    this.writer.writeValue((OutputStream)this.fos, (Object)vulnerability);
                }
            }
            return FileVisitResult.CONTINUE;
        }

        private static ObjectMapper getObjectMapper() {
            return new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).registerModule((Module)new JavaTimeModule());
        }

        private static ObjectWriter getObjectWriter() {
            CsvFactory factory = new CsvFactory();
            factory.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
            CsvMapper csvMapper = (CsvMapper)((CsvMapper)((CsvMapper.Builder)((CsvMapper.Builder)CsvMapper.builder((CsvFactory)factory).disable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).build()).registerModule((Module)new JavaTimeModule());
            CsvSchema schema = csvMapper.schemaFor(Vulnerability.class);
            return csvMapper.writer((FormatSchema)schema);
        }
    }
}

