/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.csharp.dependencies;

import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.csharp.dependencies.table.VulnerabilityReport;
import org.openrewrite.csharp.dependencies.trait.PackageReference;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.dependencies.Vulnerability;
import org.openrewrite.java.dependencies.internal.StaticVersionComparator;
import org.openrewrite.java.dependencies.internal.Version;
import org.openrewrite.java.dependencies.internal.VersionParser;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.semver.LatestPatch;
import org.openrewrite.xml.tree.Xml;

public final class DependencyVulnerabilityCheck
extends ScanningRecipe<Accumulator> {
    private final transient VersionParser versionParser = new VersionParser();
    private final transient VulnerabilityReport report = new VulnerabilityReport((Recipe)this);
    @Option(displayName="Add search markers", description="Report each vulnerability as search result markers. When enabled you can see which dependencies are bringing in vulnerable transitives in the diff view. By default these markers are omitted, making it easier to see version upgrades within the diff.", required=false)
    private final @Nullable Boolean addMarkers;
    private static final Comparator<Version> vc = new StaticVersionComparator();
    private static final LatestPatch latestPatch = new LatestPatch(null);

    public String getDisplayName() {
        return "Find and fix vulnerable Nuget dependencies";
    }

    public String getDescription() {
        return "This software composition analysis (SCA) tool detects and upgrades dependencies with publicly disclosed vulnerabilities. This recipe both generates a report of vulnerable dependencies and upgrades to newer versions with fixes. This recipe **only** upgrades to the latest **patch** version.  If a minor or major upgrade is required to reach the fixed version, this recipe will not make any changes. Vulnerability information comes from the [GitHub Security Advisory Database](https://docs.github.com/en/code-security/security-advisories/global-security-advisories/about-the-github-advisory-database), which aggregates vulnerability data from several public databases, including the [National Vulnerability Database](https://nvd.nist.gov/) maintained by the United States government. Dependencies following [Semantic Versioning](https://semver.org/) will see their _patch_ version updated where applicable.";
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        CsvMapper csvMapper = new CsvMapper();
        csvMapper.registerModule((Module)new JavaTimeModule());
        HashMap<String, List<Vulnerability>> db = new HashMap<String, List<Vulnerability>>();
        try (InputStream resourceAsStream = DependencyVulnerabilityCheck.class.getResourceAsStream("/advisories-nuget.csv");
             MappingIterator vs = csvMapper.readerWithSchemaFor(Vulnerability.class).readValues(resourceAsStream);){
            while (vs.hasNextValue()) {
                Vulnerability v = (Vulnerability)vs.nextValue();
                db.computeIfAbsent(v.getGroupArtifact(), g -> new ArrayList()).add(v);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new Accumulator(db, new HashMap<Accumulator.NameVersion, Set<Vulnerability>>());
    }

    public TreeVisitor<?, ExecutionContext> getScanner(Accumulator acc) {
        return new PackageReference.Matcher().asVisitor((ref, ctx) -> {
            String dependencyName = ref.getInclude();
            for (Vulnerability v : acc.db.getOrDefault(dependencyName, Collections.emptyList())) {
                String dependencyVersion = ref.getVersion();
                if (!this.isVulnerable(dependencyVersion, v)) continue;
                acc.vulnerabilities.computeIfAbsent(new Accumulator.NameVersion(dependencyName, dependencyVersion), nv -> new LinkedHashSet()).add(v);
                this.report.insertRow((ExecutionContext)ctx, new VulnerabilityReport.Row(v.getCve(), dependencyName, dependencyVersion, v.getFixedVersion(), DependencyVulnerabilityCheck.isFixWithPatchVersionUpdateOnly(dependencyVersion, v), v.getSummary(), v.getSeverity().toString(), 0, v.getCwes()));
            }
            return ref.getTree();
        });
    }

    private boolean isVulnerable(String dependencyVersion, Vulnerability v) {
        Version actual = this.versionParser.transform(dependencyVersion);
        if (vc.compare(actual, this.versionParser.transform(v.getIntroducedVersion())) < 0) {
            return false;
        }
        String fixedVersion = v.getFixedVersion();
        if (StringUtils.isBlank((String)fixedVersion)) {
            return true;
        }
        return vc.compare(actual, this.versionParser.transform(fixedVersion)) < 0;
    }

    private static boolean isFixWithPatchVersionUpdateOnly(String dependencyVersion, Vulnerability v) {
        return !StringUtils.isBlank((String)v.getFixedVersion()) && latestPatch.isValid(dependencyVersion, v.getFixedVersion()) && latestPatch.compare(dependencyVersion, dependencyVersion, v.getFixedVersion()) < 0;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(Accumulator acc) {
        return new PackageReference.Matcher().asVisitor((ref, ctx) -> {
            Xml.Tag tag = (Xml.Tag)ref.getTree();
            String dependencyVersion = ref.getVersion();
            Map<Boolean, List<Vulnerability>> vulnerabilities = acc.vulnerabilities.getOrDefault(new Accumulator.NameVersion(ref.getInclude(), ref.getVersion()), Collections.emptySet()).stream().collect(Collectors.partitioningBy(v -> DependencyVulnerabilityCheck.isFixWithPatchVersionUpdateOnly(dependencyVersion, v)));
            String highestFixedPatchVersion = vulnerabilities.get(true).stream().max(Comparator.comparing(v -> this.versionParser.transform(v.getFixedVersion()), vc)).map(Vulnerability::getFixedVersion).orElse(null);
            if (highestFixedPatchVersion != null) {
                tag = ref.withVersion(highestFixedPatchVersion);
            }
            List<Vulnerability> remainingVulnerabilities = vulnerabilities.get(false);
            if (Boolean.TRUE.equals(this.addMarkers) && !remainingVulnerabilities.isEmpty()) {
                tag = (Xml.Tag)SearchResult.found((Tree)tag, (String)("This dependency has the following vulnerabilities:\n" + remainingVulnerabilities.stream().map(v -> String.format("%s (%s severity%s) - %s", new Object[]{v.getCve(), v.getSeverity(), StringUtils.isBlank((String)v.getFixedVersion()) ? "" : ", fixed in " + v.getFixedVersion(), v.getSummary()})).collect(Collectors.joining("\n"))));
            }
            return tag;
        });
    }

    @ConstructorProperties(value={"addMarkers"})
    @Generated
    public DependencyVulnerabilityCheck(@Nullable Boolean addMarkers) {
        this.addMarkers = addMarkers;
    }

    @Generated
    public VersionParser getVersionParser() {
        return this.versionParser;
    }

    @Generated
    public VulnerabilityReport getReport() {
        return this.report;
    }

    @Generated
    public @Nullable Boolean getAddMarkers() {
        return this.addMarkers;
    }

    @NonNull
    @Generated
    public String toString() {
        return "DependencyVulnerabilityCheck(versionParser=" + this.getVersionParser() + ", report=" + (Object)((Object)this.getReport()) + ", addMarkers=" + this.getAddMarkers() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DependencyVulnerabilityCheck)) {
            return false;
        }
        DependencyVulnerabilityCheck other = (DependencyVulnerabilityCheck)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$addMarkers = this.getAddMarkers();
        Boolean other$addMarkers = other.getAddMarkers();
        return !(this$addMarkers == null ? other$addMarkers != null : !((Object)this$addMarkers).equals(other$addMarkers));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof DependencyVulnerabilityCheck;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $addMarkers = this.getAddMarkers();
        result = result * 59 + ($addMarkers == null ? 43 : ((Object)$addMarkers).hashCode());
        return result;
    }

    public static final class Accumulator {
        private final Map<String, List<Vulnerability>> db;
        private final Map<NameVersion, Set<Vulnerability>> vulnerabilities;

        @ConstructorProperties(value={"db", "vulnerabilities"})
        @Generated
        public Accumulator(Map<String, List<Vulnerability>> db, Map<NameVersion, Set<Vulnerability>> vulnerabilities) {
            this.db = db;
            this.vulnerabilities = vulnerabilities;
        }

        @Generated
        public Map<String, List<Vulnerability>> getDb() {
            return this.db;
        }

        @Generated
        public Map<NameVersion, Set<Vulnerability>> getVulnerabilities() {
            return this.vulnerabilities;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accumulator)) {
                return false;
            }
            Accumulator other = (Accumulator)o;
            Map<String, List<Vulnerability>> this$db = this.getDb();
            Map<String, List<Vulnerability>> other$db = other.getDb();
            if (this$db == null ? other$db != null : !((Object)this$db).equals(other$db)) {
                return false;
            }
            Map<NameVersion, Set<Vulnerability>> this$vulnerabilities = this.getVulnerabilities();
            Map<NameVersion, Set<Vulnerability>> other$vulnerabilities = other.getVulnerabilities();
            return !(this$vulnerabilities == null ? other$vulnerabilities != null : !((Object)this$vulnerabilities).equals(other$vulnerabilities));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, List<Vulnerability>> $db = this.getDb();
            result = result * 59 + ($db == null ? 43 : ((Object)$db).hashCode());
            Map<NameVersion, Set<Vulnerability>> $vulnerabilities = this.getVulnerabilities();
            result = result * 59 + ($vulnerabilities == null ? 43 : ((Object)$vulnerabilities).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "DependencyVulnerabilityCheck.Accumulator(db=" + this.getDb() + ", vulnerabilities=" + this.getVulnerabilities() + ")";
        }

        static final class NameVersion {
            private final String name;
            private final String version;

            @ConstructorProperties(value={"name", "version"})
            @Generated
            public NameVersion(String name, String version) {
                this.name = name;
                this.version = version;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public String getVersion() {
                return this.version;
            }

            @Generated
            public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof NameVersion)) {
                    return false;
                }
                NameVersion other = (NameVersion)o;
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                String this$version = this.getVersion();
                String other$version = other.getVersion();
                return !(this$version == null ? other$version != null : !this$version.equals(other$version));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                String $version = this.getVersion();
                result = result * 59 + ($version == null ? 43 : $version.hashCode());
                return result;
            }

            @NonNull
            @Generated
            public String toString() {
                return "DependencyVulnerabilityCheck.Accumulator.NameVersion(name=" + this.getName() + ", version=" + this.getVersion() + ")";
            }
        }
    }
}

