/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.circleci;

import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.yaml.ChangeValue;

public class UpdateImage
extends Recipe {
    @Option(displayName="Image", description="Image to use.", example="circleci/openjdk:jdk")
    private final String image;

    public UpdateImage(String image) {
        this.image = image;
    }

    public String getDisplayName() {
        return "Update CircleCI image";
    }

    public String getDescription() {
        return "See the list of [pre-built CircleCI images](https://circleci.com/docs/2.0/circleci-images/).";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindSourceFiles(".circleci/config.yml"), (TreeVisitor)new ChangeValue("$.jobs.build.machine.image", this.image).getVisitor());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateImage)) {
            return false;
        }
        UpdateImage other = (UpdateImage)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        return !(this$image == null ? other$image != null : !this$image.equals(other$image));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UpdateImage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        return result;
    }

    public String getImage() {
        return this.image;
    }
}

