/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.xml.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.openjax.xml.api.CharacterDatas;

public class XmlElement
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 3766554839993594188L;
    private final String name;
    private Map<String, Object> attributes;
    private Collection<XmlElement> elements;

    public XmlElement(String name, Map<String, Object> attributes, Collection<XmlElement> elements) {
        this.name = name;
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name == " + name);
        }
        this.attributes = attributes;
        this.elements = elements;
    }

    public String getName() {
        return this.name;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setElements(Collection<XmlElement> elements) {
        this.elements = elements;
    }

    public Collection<XmlElement> getElements() {
        return this.elements;
    }

    public XmlElement clone() {
        try {
            XmlElement clone = (XmlElement)super.clone();
            if (this.attributes != null) {
                clone.attributes = new HashMap<String, Object>(this.attributes);
            }
            if (this.elements != null) {
                clone.elements = new ArrayList<XmlElement>(this.elements);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XmlElement)) {
            return false;
        }
        XmlElement that = (XmlElement)obj;
        return this.name.equals(that.name) && (this.attributes == null ? that.attributes == null : this.attributes.equals(that.attributes)) && (this.elements == null ? that.elements == null : that.elements != null && this.elements.size() == that.elements.size() && this.elements.containsAll(that.elements));
    }

    public int hashCode() {
        int hashCode = 9;
        hashCode ^= 31 * this.name.hashCode();
        if (this.attributes != null) {
            hashCode ^= 31 * this.attributes.hashCode();
        }
        if (this.elements != null) {
            hashCode ^= 31 * this.elements.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("<");
        builder.append(this.name);
        if (this.attributes != null && this.attributes.size() > 0) {
            for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
                builder.append(' ').append(entry.getKey()).append("=\"");
                if (entry.getValue() != null) {
                    builder.append(CharacterDatas.escapeForAttr(new StringBuilder(String.valueOf(entry.getValue())), '\"'));
                } else {
                    builder.append("null");
                }
                builder.append('\"');
            }
        }
        if (this.elements == null || this.elements.size() == 0) {
            return builder.append("/>").toString();
        }
        builder.append('>');
        for (XmlElement element : this.elements) {
            builder.append("\n  ").append(element.toString().replaceAll("\n", "\n  "));
        }
        return builder.append("\n</").append(this.name).append('>').toString();
    }
}

