/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.xml.api;

public final class CharacterDatas {
    private static void assertRange(int fromIndex, int toIndex, CharSequence string) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (toIndex > string.length()) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
    }

    private static StringBuilder escape(StringBuilder string, char quote, int fromIndex, int toIndex) {
        for (int i = toIndex - 1; i >= fromIndex; --i) {
            char ch = string.charAt(i);
            if (ch == '&') {
                string.replace(i, i + 1, "&amp;");
            } else if (ch == '>') {
                string.replace(i, i + 1, "&gt;");
            } else if (ch == '<') {
                string.replace(i, i + 1, "&lt;");
            }
            if (quote != ch) continue;
            if (ch == '\'') {
                string.replace(i, i + 1, "&apos;");
                continue;
            }
            if (ch != '\"') continue;
            string.replace(i, i + 1, "&quot;");
        }
        return string;
    }

    public static String escapeForAttr(CharSequence string, char quote) {
        if (quote != '\"' && quote != '\'') {
            throw new IllegalArgumentException("Illegal quote character: " + quote);
        }
        return CharacterDatas.escape(string instanceof StringBuilder ? (StringBuilder)string : new StringBuilder(string), quote, 0, string.length()).toString();
    }

    public static String escapeForAttr(CharSequence string, char quote, int fromIndex, int toIndex) {
        if (quote != '\"' && quote != '\'') {
            throw new IllegalArgumentException("Illegal quote character: " + quote);
        }
        CharacterDatas.assertRange(fromIndex, toIndex, string);
        return CharacterDatas.escape(string instanceof StringBuilder ? (StringBuilder)string : new StringBuilder(string), quote, fromIndex, toIndex).toString();
    }

    public static String escapeForElem(CharSequence string) {
        return CharacterDatas.escape(string instanceof StringBuilder ? (StringBuilder)string : new StringBuilder(string), '\u0000', 0, string.length()).toString();
    }

    public static String escapeForElem(CharSequence string, int fromIndex, int toIndex) {
        CharacterDatas.assertRange(fromIndex, toIndex, string);
        return CharacterDatas.escape(string instanceof StringBuilder ? (StringBuilder)string : new StringBuilder(string), '\u0000', fromIndex, toIndex).toString();
    }

    private static StringBuilder unescape(StringBuilder string, char quote, int fromIndex, int toIndex) {
        int pos = 0;
        int start = -1;
        for (int i = toIndex - 1; i >= fromIndex; --i) {
            char ch = string.charAt(i);
            if (start >= 0) {
                if (pos == 0) {
                    if (ch != 'p' && ch != 't' && (quote != '\u0000' && quote != '\'' || ch != 's')) {
                        start = -1;
                        continue;
                    }
                    ++pos;
                    continue;
                }
                if (pos == 1) {
                    if (ch != 'm' && ch != 'g' && ch != 'l' && (quote != '\u0000' && quote != '\"' && quote != '\'' || ch != 'o')) {
                        start = -1;
                        continue;
                    }
                    ++pos;
                    continue;
                }
                if (pos == 2) {
                    if (ch == '&') {
                        string.replace(i, start + 1, string.charAt(i + 1) == 'g' ? ">" : "<");
                        start = -1;
                        continue;
                    }
                    if (ch != 'a' && ch != 'p' && (quote != '\u0000' && quote != '\"' || ch != 'u')) {
                        start = -1;
                        continue;
                    }
                    ++pos;
                    continue;
                }
                if (pos == 3) {
                    if (ch == '&') {
                        string.replace(i, start + 1, "&");
                        start = -1;
                        continue;
                    }
                    if (!(quote == '\u0000' || quote == '\'' && ch == 'a' || quote == '\"' && ch == 'q')) {
                        start = -1;
                        continue;
                    }
                    ++pos;
                    continue;
                }
                if (pos == 4) {
                    if (ch == '&') {
                        string.replace(i, start + 1, string.charAt(i + 1) == 'a' ? "'" : "\"");
                        start = -1;
                        continue;
                    }
                    start = -1;
                }
            }
            if (ch != ';') continue;
            start = i;
            pos = 0;
        }
        return string;
    }

    public static String unescapeFromAttr(CharSequence string, char quote) {
        return CharacterDatas.unescape(string instanceof StringBuilder ? (StringBuilder)string : new StringBuilder(string), quote, 0, string.length()).toString();
    }

    public static String unescapeFromAttr(CharSequence string, char quote, int fromIndex, int toIndex) {
        CharacterDatas.assertRange(fromIndex, toIndex, string);
        return CharacterDatas.unescape(string instanceof StringBuilder ? (StringBuilder)string : new StringBuilder(string), quote, fromIndex, toIndex).toString();
    }

    public static String unescapeFromElem(CharSequence string) {
        return CharacterDatas.unescape(string instanceof StringBuilder ? (StringBuilder)string : new StringBuilder(string), '\u0000', 0, string.length()).toString();
    }

    public static String unescapeFromElem(CharSequence string, int fromIndex, int toIndex) {
        CharacterDatas.assertRange(fromIndex, toIndex, string);
        return CharacterDatas.unescape(string instanceof StringBuilder ? (StringBuilder)string : new StringBuilder(string), '\u0000', fromIndex, toIndex).toString();
    }

    private CharacterDatas() {
    }
}

