/* Copyright (c) 2016 OpenJAX
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * You should have received a copy of The MIT License (MIT) along with this
 * program. If not, see <http://opensource.org/licenses/MIT/>.
 */

package org.openjax.xml.api;

import org.xml.sax.SAXException;

/**
 * A {@link SAXException} that signifies a validation exception due to an
 * attempt to parse a remote document while offline.
 */
public class OfflineValidationException extends ValidationException {
  private static final long serialVersionUID = -6362835686505809259L;

  /**
   * Creates a new {@code OfflineValidationException}.
   */
  public OfflineValidationException() {
    super();
  }

  /**
   * Creates a new {@code OfflineValidationException}.
   *
   * @param message The detail message.
   */
  public OfflineValidationException(final String message) {
    super(message);
  }

  /**
   * Creates a new {@code OfflineValidationException}.
   *
   * @param cause The cause.
   */
  public OfflineValidationException(final Exception cause) {
    super(cause);
  }

  /**
   * Creates a new {@code OfflineValidationException}.
   *
   * @param message The detail message.
   * @param cause The cause.
   */
  public OfflineValidationException(final String message, final Exception cause) {
    super(message, cause);
  }
}