/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.statistics.distribution;

import org.openimaj.feature.DoubleFV;
import org.openimaj.util.array.ArrayUtils;

public class Histogram
extends DoubleFV {
    private static final long serialVersionUID = 1L;

    public Histogram(int nbins) {
        super(nbins);
    }

    public Histogram(DoubleFV ... hs) {
        double[][] hists = new double[hs.length][];
        for (int i = 0; i < hs.length; ++i) {
            hists[i] = (double[])hs[i].values;
        }
        this.values = ArrayUtils.concatenate((double[][])hists);
    }

    public Histogram(double[] data) {
        super(data);
    }

    public void normalise() {
        int i;
        double sum = 0.0;
        for (i = 0; i < ((double[])this.values).length; ++i) {
            sum += ((double[])this.values)[i];
        }
        i = 0;
        while (i < ((double[])this.values).length) {
            double[] dArray = (double[])this.values;
            int n = i++;
            dArray[n] = dArray[n] / sum;
        }
    }

    public void normaliseL1() {
        int i;
        double sum = 0.0;
        for (i = 0; i < ((double[])this.values).length; ++i) {
            sum += Math.abs(((double[])this.values)[i]);
        }
        if (sum != 0.0) {
            i = 0;
            while (i < ((double[])this.values).length) {
                double[] dArray = (double[])this.values;
                int n = i++;
                dArray[n] = dArray[n] / sum;
            }
        }
    }

    public void normaliseL2() {
        int i;
        double sumsq = 0.0;
        for (i = 0; i < ((double[])this.values).length; ++i) {
            sumsq += ((double[])this.values)[i] * ((double[])this.values)[i];
        }
        if (sumsq != 0.0) {
            i = 0;
            while (i < ((double[])this.values).length) {
                double[] dArray = (double[])this.values;
                int n = i++;
                dArray[n] = dArray[n] / Math.sqrt(sumsq);
            }
        }
    }

    public double max() {
        double max = Double.MIN_VALUE;
        for (int i = 0; i < ((double[])this.values).length; ++i) {
            max = Math.max(((double[])this.values)[i], max);
        }
        return max;
    }

    @Override
    public Histogram clone() {
        return (Histogram)super.clone();
    }

    public Histogram combine(Histogram ... hs) {
        int hsLength = hs == null ? 0 : hs.length;
        double[][] hists = new double[1 + hsLength][];
        hists[0] = (double[])this.values;
        for (int i = 0; i < hsLength; ++i) {
            hists[i + 1] = (double[])hs[i].values;
        }
        return new Histogram(ArrayUtils.concatenate((double[][])hists));
    }
}

