/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature.local.quantised;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import org.openimaj.feature.IntFV;
import org.openimaj.feature.local.LocalFeature;
import org.openimaj.feature.local.Location;

public class QuantisedLocalFeature<L extends Location>
implements LocalFeature<L, IntFV> {
    public L location;
    public int id;

    public QuantisedLocalFeature() {
    }

    public QuantisedLocalFeature(L location, int id) {
        this.location = location;
        this.id = id;
    }

    public void writeBinary(DataOutput out) throws IOException {
        this.location.writeBinary(out);
        out.writeInt(this.id);
    }

    public void writeASCII(PrintWriter out) throws IOException {
        this.location.writeASCII(out);
        out.println(this.id);
    }

    public void readBinary(DataInput in) throws IOException {
        this.location.readBinary(in);
        this.id = in.readInt();
    }

    public void readASCII(Scanner in) throws IOException {
        this.location.readASCII(in);
        this.id = Integer.parseInt(in.next());
    }

    public byte[] binaryHeader() {
        return ("QLFI." + new String(this.location.binaryHeader())).getBytes();
    }

    public String asciiHeader() {
        return this.getClass().getName() + "." + this.location.asciiHeader();
    }

    @Override
    public IntFV getFeatureVector() {
        return new IntFV(new int[]{this.id});
    }

    @Override
    public L getLocation() {
        return this.location;
    }
}

