/*
 * Decompiled with CFR 0.152.
 */
package org.opengauss.clusterhealthy;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.opengauss.clusterhealthy.ClusterHeartBeat;
import org.opengauss.core.QueryExecutor;
import org.opengauss.log.Log;
import org.opengauss.log.Logger;
import org.opengauss.util.HostSpec;

public class ClusterHeartBeatFailureMaster
extends ClusterHeartBeat {
    public Map<HostSpec, HostSpec> failureMap = new ConcurrentHashMap<HostSpec, HostSpec>();
    private static volatile ClusterHeartBeatFailureMaster clusterHeartBeatFailureMaster;
    private static Log LOGGER;

    private ClusterHeartBeatFailureMaster() {
    }

    public static synchronized ClusterHeartBeatFailureMaster getInstance() {
        if (clusterHeartBeatFailureMaster == null) {
            clusterHeartBeatFailureMaster = new ClusterHeartBeatFailureMaster();
        }
        return clusterHeartBeatFailureMaster;
    }

    public void run() {
        HashMap<HostSpec, HostSpec> failureMapClone = new HashMap<HostSpec, HostSpec>(this.failureMap);
        LOGGER.debug("failure node " + failureMapClone);
        for (Map.Entry<HostSpec, HostSpec> next : failureMapClone.entrySet()) {
            HostSpec current;
            HostSpec key = next.getKey();
            HostSpec value = next.getValue();
            Set<Properties> properties = this.getProperties(key);
            QueryExecutor queryExecutor = null;
            try {
                queryExecutor = this.getQueryExecutor(key, properties);
                this.failureMap.remove(key);
            }
            catch (SQLException e) {
                LOGGER.error(key.toString() + " tryConnect failure.");
                continue;
            }
            boolean isMaster = this.nodeRoleIsMaster(queryExecutor);
            if (isMaster) {
                boolean currentIsMaster;
                current = value;
                while (this.failureMap.containsKey(current)) {
                    current = this.failureMap.get(current);
                }
                if (!this.getClusterRelationship().containsKey(current)) continue;
                Set<Properties> prop = this.getProperties(key);
                try {
                    QueryExecutor currentQueryExecutor = this.getQueryExecutor(current, prop);
                    currentIsMaster = this.nodeRoleIsMaster(currentQueryExecutor);
                }
                catch (SQLException e) {
                    currentIsMaster = false;
                }
                if (currentIsMaster) continue;
                Set<HostSpec> set = this.getClusterSalveNode(current);
                set.add(current);
                this.addClusterNode(key, set.toArray(new HostSpec[0]));
                continue;
            }
            current = value;
            while (this.failureMap.containsKey(current)) {
                if (current == this.failureMap.get(current)) {
                    this.failureMap.remove(current);
                    break;
                }
                current = this.failureMap.get(current);
            }
            this.addClusterNode(current, key);
        }
    }

    public void addFailureMaster(HostSpec hostSpec, HostSpec maseterNode) {
        this.failureMap.put(hostSpec, maseterNode);
    }

    public Map<HostSpec, HostSpec> getFailureMaster() {
        return this.failureMap;
    }

    public void remove(HostSpec hostSpec) {
        this.failureMap.remove(hostSpec);
    }

    @Override
    public void clear() {
        this.failureMap.clear();
    }

    static {
        LOGGER = Logger.getLogger(ClusterHeartBeatFailureMaster.class.getName());
    }
}

