/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.evaluator.fhir.dal;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.gclient.IQuery;
import ca.uhn.fhir.util.BundleUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.cql.evaluator.fhir.dal.FhirDal;

public class RestFhirDal
implements FhirDal {
    private IGenericClient client;

    public RestFhirDal(IGenericClient client) {
        this.client = client;
    }

    @Override
    public IBaseResource read(IIdType id) {
        return (IBaseResource)this.client.read().resource(id.getResourceType()).withId(id).execute();
    }

    @Override
    public void create(IBaseResource resource) {
        this.client.create().resource(resource).execute();
    }

    @Override
    public void update(IBaseResource resource) {
        this.client.update().resource(resource).execute();
    }

    @Override
    public void delete(IIdType id) {
        this.client.delete().resourceById(id).execute();
    }

    @Override
    public Iterable<IBaseResource> search(String resourceType) {
        IBaseBundle bundle = (IBaseBundle)this.client.search().forResource(resourceType).execute();
        return BundleUtil.toListOfResources((FhirContext)this.client.getFhirContext(), (IBaseBundle)bundle);
    }

    @Override
    public Iterable<IBaseResource> searchByUrl(String resourceType, String url) {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("url", Arrays.asList(url));
        IBaseBundle bundle = (IBaseBundle)((IQuery)this.client.search().forResource(resourceType).whereMap(params)).execute();
        return BundleUtil.toListOfResources((FhirContext)this.client.getFhirContext(), (IBaseBundle)bundle);
    }
}

