/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.evaluator.fhir.dal;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.util.BundleUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.NotImplementedException;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.UriType;
import org.opencds.cqf.cql.evaluator.fhir.dal.FhirDal;

public class BundleFhirDal
implements FhirDal {
    protected FhirContext context;
    protected IBaseBundle bundle;
    protected IFhirPath fhirPath;

    public BundleFhirDal(FhirContext context, IBaseBundle bundle) {
        this.context = context;
        this.bundle = bundle;
        this.fhirPath = this.context.newFhirPath();
    }

    @Override
    public IBaseResource read(IIdType id) {
        List resources = BundleUtil.toListOfResourcesOfType((FhirContext)this.context, (IBaseBundle)this.bundle, (Class)this.context.getResourceDefinition(id.getResourceType()).getImplementingClass());
        for (IBaseResource resource : resources) {
            if (!resource.getIdElement().getIdPart().equals(id.getIdPart())) continue;
            return resource;
        }
        return null;
    }

    @Override
    public void create(IBaseResource resource) {
        throw new NotImplementedException();
    }

    @Override
    public void update(IBaseResource resource) {
        throw new NotImplementedException();
    }

    @Override
    public void delete(IIdType id) {
        throw new NotImplementedException();
    }

    @Override
    public Iterable<IBaseResource> search(String resourceType) {
        return BundleUtil.toListOfResourcesOfType((FhirContext)this.context, (IBaseBundle)this.bundle, (Class)this.context.getResourceDefinition(resourceType).getImplementingClass());
    }

    @Override
    public Iterable<IBaseResource> searchByUrl(String resourceType, String url) {
        List resources = BundleUtil.toListOfResourcesOfType((FhirContext)this.context, (IBaseBundle)this.bundle, (Class)this.context.getResourceDefinition(resourceType).getImplementingClass());
        ArrayList<IBaseResource> returnList = new ArrayList<IBaseResource>();
        for (IBaseResource resource : resources) {
            Optional urlString = this.fhirPath.evaluateFirst((IBase)resource, "url", UriType.class);
            if (!urlString.isPresent() || !((String)((UriType)urlString.get()).getValue()).equals(url)) continue;
            returnList.add(resource);
        }
        return returnList;
    }
}

