/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.evaluator.fhir;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.api.BundleInclusionRule;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.BundleLinks;
import ca.uhn.fhir.rest.api.IVersionSpecificBundleFactory;
import ca.uhn.fhir.util.BundleUtil;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.FileUtils;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class DirectoryBundler {
    private static final Logger logger = LoggerFactory.getLogger(DirectoryBundler.class);
    private FhirContext fhirContext;
    private IParser xml = null;
    private IParser json = null;

    @Inject
    public DirectoryBundler(FhirContext fhirContext) {
        this.fhirContext = fhirContext;
    }

    public IBaseBundle bundle(String path) {
        URI uri;
        Objects.requireNonNull(path, "path must not be null.");
        try {
            if (!path.startsWith("file:/") && !path.matches("\\w+?://.*")) {
                File file = new File(path);
                uri = file.toURI();
            } else {
                uri = new URI(path);
            }
        }
        catch (Exception e) {
            logger.error(String.format("error parsing uri from path: %s", path), (Throwable)e);
            throw new RuntimeException(e);
        }
        Collection<File> files = uri.getScheme() != null && uri.getScheme().startsWith("jar") ? this.listJar(uri, path) : this.listDirectory(uri.getPath());
        return this.bundleFiles(path, files);
    }

    private Collection<File> listJar(URI uri, String path) {
        Collection collection;
        block8: {
            FileSystem fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
            Path jarPath = fileSystem.getPath(path, new String[0]);
            Stream<Path> walk = Files.walk(jarPath, FileVisitOption.FOLLOW_LINKS);
            try {
                collection = walk.map(x -> x.toFile()).filter(x -> x.isFile()).filter(x -> x.getName().endsWith("json") || x.getName().endsWith("xml")).collect(Collectors.toList());
                if (walk == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (walk != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.error(String.format("error attempting to list jar: %s", uri.toString()));
                    throw new RuntimeException(e);
                }
            }
            walk.close();
        }
        return collection;
    }

    private Collection<File> listDirectory(String path) {
        File resourceDirectory = new File(path);
        if (!resourceDirectory.getAbsoluteFile().exists()) {
            throw new IllegalArgumentException(String.format("The specified path to resource files does not exist: %s", path));
        }
        if (resourceDirectory.getAbsoluteFile().isDirectory()) {
            return FileUtils.listFiles((File)resourceDirectory, (String[])new String[]{"xml", "json"}, (boolean)true);
        }
        if (path.toLowerCase().endsWith("xml") || path.toLowerCase().endsWith("json")) {
            return Collections.singletonList(resourceDirectory);
        }
        throw new IllegalArgumentException(String.format("path was not a directory or a recognized FHIR file format (XML, JSON) : %s", path));
    }

    private IBaseBundle bundleFiles(String rootPath, Collection<File> files) {
        ArrayList<IBaseResource> resources = new ArrayList<IBaseResource>();
        for (File f : files) {
            IBaseResource resource = this.parseFile(f);
            if (resource == null) continue;
            if (resource instanceof IBaseBundle) {
                List<IBaseResource> innerResources = this.flatten(this.fhirContext, (IBaseBundle)resource);
                resources.addAll(innerResources);
                continue;
            }
            resources.add(resource);
        }
        IVersionSpecificBundleFactory bundleFactory = this.fhirContext.newBundleFactory();
        BundleLinks bundleLinks = new BundleLinks(rootPath, null, true, BundleTypeEnum.COLLECTION);
        bundleFactory.addRootPropertiesToBundle("bundled-directory", bundleLinks, Integer.valueOf(resources.size()), null);
        bundleFactory.addResourcesToBundle(resources, BundleTypeEnum.COLLECTION, "", BundleInclusionRule.BASED_ON_INCLUDES, null);
        return (IBaseBundle)bundleFactory.getResourceBundle();
    }

    private IBaseResource parseFile(File f) {
        try {
            String resource = FileUtils.readFileToString((File)f, (Charset)Charset.forName("UTF-8"));
            IParser selectedParser = this.selectParser(f.getName());
            return selectedParser.parseResource(resource);
        }
        catch (Exception e) {
            logger.warn("Error parsing resource {}: {}", (Object)f.getAbsolutePath(), (Object)e.getMessage());
            return null;
        }
    }

    private IParser selectParser(String filename) {
        if (filename.toLowerCase().endsWith("json")) {
            if (this.json == null) {
                this.json = this.fhirContext.newJsonParser();
            }
            return this.json;
        }
        if (this.xml == null) {
            this.xml = this.fhirContext.newXmlParser();
        }
        return this.xml;
    }

    private List<IBaseResource> flatten(FhirContext fhirContext, IBaseBundle bundle) {
        ArrayList<IBaseResource> resources = new ArrayList<IBaseResource>();
        List bundleResources = BundleUtil.toListOfResources((FhirContext)fhirContext, (IBaseBundle)bundle);
        for (IBaseResource r : bundleResources) {
            if (r instanceof IBaseBundle) {
                List<IBaseResource> innerResources = this.flatten(fhirContext, (IBaseBundle)r);
                resources.addAll(innerResources);
                continue;
            }
            resources.add(r);
        }
        return resources;
    }
}

