/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.evaluator.fhir;

import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AdditionalRequestHeadersInterceptor {
    private final Map<String, List<String>> myAdditionalHttpHeaders = new HashMap<String, List<String>>();

    public AdditionalRequestHeadersInterceptor() {
    }

    public AdditionalRequestHeadersInterceptor(Map<String, List<String>> theHeaders) {
        this();
        if (theHeaders != null) {
            this.myAdditionalHttpHeaders.putAll(theHeaders);
        }
    }

    public void addHeaderValue(String headerName, String headerValue) {
        Objects.requireNonNull(headerName, "headerName cannot be null");
        Objects.requireNonNull(headerValue, "headerValue cannot be null");
        this.getHeaderValues(headerName).add(headerValue);
    }

    public void addAllHeaderValues(String headerName, List<String> headerValues) {
        Objects.requireNonNull(headerName, "headerName cannot be null");
        Objects.requireNonNull(headerValues, "headerValues cannot be null");
        this.getHeaderValues(headerName).addAll(headerValues);
    }

    private List<String> getHeaderValues(String headerName) {
        if (this.myAdditionalHttpHeaders.get(headerName) == null) {
            this.myAdditionalHttpHeaders.put(headerName, new ArrayList());
        }
        return this.myAdditionalHttpHeaders.get(headerName);
    }

    @Hook(value=Pointcut.CLIENT_REQUEST)
    public void interceptRequest(IHttpRequest theRequest) {
        for (Map.Entry<String, List<String>> header : this.myAdditionalHttpHeaders.entrySet()) {
            for (String headerValue : header.getValue()) {
                if (headerValue == null) continue;
                theRequest.addHeader(header.getKey(), headerValue);
            }
        }
    }
}

