/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.evaluator.engine.terminology;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.util.BundleUtil;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.cql.engine.runtime.Code;
import org.opencds.cqf.cql.engine.terminology.CodeSystemInfo;
import org.opencds.cqf.cql.engine.terminology.TerminologyProvider;
import org.opencds.cqf.cql.engine.terminology.ValueSetInfo;
import org.opencds.cqf.cql.evaluator.engine.util.ValueSetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleTerminologyProvider
implements TerminologyProvider {
    private static final Logger logger = LoggerFactory.getLogger(BundleTerminologyProvider.class);
    private FhirContext fhirContext;
    private IFhirPath fhirPath;
    private List<? extends IBaseResource> valueSets;
    private Map<String, Iterable<Code>> valueSetIndex = new HashMap<String, Iterable<Code>>();
    private boolean initialized = false;

    public BundleTerminologyProvider(FhirContext fhirContext, IBaseBundle bundle) {
        Objects.requireNonNull(fhirContext, "fhirContext can not be null.");
        Objects.requireNonNull(bundle, "bundle can not be null.");
        this.fhirContext = fhirContext;
        this.fhirPath = fhirContext.newFhirPath();
        this.valueSets = BundleUtil.toListOfResourcesOfType((FhirContext)this.fhirContext, (IBaseBundle)bundle, (Class)this.fhirContext.getResourceDefinition("ValueSet").getImplementingClass());
    }

    public boolean in(Code code, ValueSetInfo valueSet) {
        Objects.requireNonNull(code, "code can not be null when using 'expand'");
        Objects.requireNonNull(valueSet, "valueSet can not be null when using 'expand'");
        Iterable<Code> codes = this.expand(valueSet);
        this.checkExpansion(codes, valueSet);
        for (Code c : codes) {
            if (!c.getCode().equals(code.getCode()) || !c.getSystem().equals(code.getSystem())) continue;
            return true;
        }
        return false;
    }

    public Iterable<Code> expand(ValueSetInfo valueSet) {
        Objects.requireNonNull(valueSet, "valueSet can not be null when using 'expand'");
        this.initialize();
        if (!this.valueSetIndex.containsKey(valueSet.getId())) {
            throw new IllegalArgumentException(String.format("Unable to locate ValueSet %s", valueSet.getId()));
        }
        return this.valueSetIndex.get(valueSet.getId());
    }

    public Code lookup(Code code, CodeSystemInfo codeSystem) {
        if (code.getSystem() == null) {
            return null;
        }
        if (code.getSystem().equals(codeSystem.getId()) && (code.getVersion() == null || code.getVersion().equals(codeSystem.getVersion()))) {
            logger.warn("Unvalidated CodeSystem lookup: {} in {}", (Object)code.toString(), (Object)codeSystem.getId());
            return code;
        }
        return null;
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        for (IBaseResource iBaseResource : this.valueSets) {
            String url = ValueSetUtil.getUrl(this.fhirContext, iBaseResource);
            Iterable<Code> codes = ValueSetUtil.getCodesInExpansion(this.fhirContext, iBaseResource);
            if (codes == null) {
                logger.warn("ValueSet {} is not expanded. Falling back to compose definition. This will potentially produce incorrect results. ", (Object)url);
                codes = ValueSetUtil.getCodesInCompose(this.fhirContext, iBaseResource);
            } else {
                Boolean isNaiveExpansion = this.isNaiveExpansion(iBaseResource);
                if (isNaiveExpansion != null && isNaiveExpansion.booleanValue()) {
                    logger.warn("Codes expanded without a terminology server, some results may not be correct.");
                }
            }
            if (codes == null) {
                codes = Collections.emptySet();
            }
            this.valueSetIndex.put(url, codes);
        }
        this.initialized = true;
    }

    private Boolean isNaiveExpansion(IBaseResource resource) {
        IBase expansion = ValueSetUtil.getExpansion(this.fhirContext, resource);
        if (expansion != null) {
            List<IBase> naiveParameters;
            Iterator<IBase> iterator;
            List<IBase> object = ValueSetUtil.getExpansionParameters(expansion, this.fhirPath, ".where(name = 'naive').value");
            if (object instanceof IBase) {
                return this.resolveNaiveBoolean((IBase)object);
            }
            if (object instanceof Iterable && (iterator = (naiveParameters = object).iterator()).hasNext()) {
                IBase param = iterator.next();
                return this.resolveNaiveBoolean(param);
            }
        }
        return null;
    }

    private Boolean resolveNaiveBoolean(IBase param) {
        if (param.fhirType().equals("boolean")) {
            return (Boolean)((IPrimitiveType)param).getValue();
        }
        return null;
    }

    private void checkExpansion(Iterable<Code> expandedCodes, ValueSetInfo valueSet) {
        if (expandedCodes != null && !Iterables.isEmpty(expandedCodes)) {
            return;
        }
        IBaseResource resource = null;
        for (IBaseResource iBaseResource : this.valueSets) {
            String idPart = iBaseResource.getIdElement().getIdPart();
            String versionIdPart = iBaseResource.getIdElement().getVersionIdPart();
            if (!valueSet.getId().equals(idPart) && !valueSet.getId().endsWith(idPart) && !valueSet.getId().endsWith(idPart + "|" + versionIdPart)) continue;
            resource = iBaseResource;
        }
        if (resource == null) {
            throw new IllegalArgumentException(String.format("Unable to locate ValueSet %s", valueSet.getId()));
        }
        if (this.containsExpansionLogic(resource)) {
            String msg = "ValueSet {} not expanded and compose contained expansion logic.";
            logger.error(msg);
            throw new IllegalArgumentException(msg);
        }
    }

    private boolean containsExpansionLogic(IBaseResource resource) {
        List<IBase> includeFilters = ValueSetUtil.getIncludeFilters(this.fhirContext, resource);
        if (includeFilters != null && !includeFilters.isEmpty()) {
            return true;
        }
        List<IBase> excludeFilters = ValueSetUtil.getExcludeFilters(this.fhirContext, resource);
        return excludeFilters != null && !excludeFilters.isEmpty();
    }
}

