/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.evaluator.cql2elm.content.fhir;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.util.BundleUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.opencds.cqf.cql.evaluator.cql2elm.content.fhir.BaseFhirLibrarySourceProvider;
import org.opencds.cqf.cql.evaluator.cql2elm.util.LibraryVersionSelector;
import org.opencds.cqf.cql.evaluator.fhir.adapter.AdapterFactory;

public class BundleFhirLibrarySourceProvider
extends BaseFhirLibrarySourceProvider {
    private IBaseBundle bundle;
    private FhirContext fhirContext;
    private LibraryVersionSelector libraryVersionSelector;

    public BundleFhirLibrarySourceProvider(FhirContext fhirContext, IBaseBundle bundle, AdapterFactory adapterFactory, LibraryVersionSelector libraryVersionSelector) {
        super(adapterFactory);
        this.fhirContext = Objects.requireNonNull(fhirContext, "fhirContext can not be null");
        this.bundle = Objects.requireNonNull(bundle, "bundle can not be null");
        this.libraryVersionSelector = Objects.requireNonNull(libraryVersionSelector, "libraryVersionSelector can not be null");
        if (!this.bundle.getStructureFhirVersionEnum().equals((Object)fhirContext.getVersion().getVersion())) {
            throw new IllegalArgumentException("the FHIR versions of bundle and fhirContext must match");
        }
    }

    protected IBaseBundle getBundle() {
        return this.bundle;
    }

    protected FhirContext getFhirContext() {
        return this.fhirContext;
    }

    @Override
    protected IBaseResource getLibrary(VersionedIdentifier libraryIdentifier) {
        List resources = BundleUtil.toListOfResourcesOfType((FhirContext)this.getFhirContext(), (IBaseBundle)this.getBundle(), (Class)this.getFhirContext().getResourceDefinition("Library").getImplementingClass());
        if (resources == null || resources.isEmpty()) {
            return null;
        }
        Collection libraries = resources.stream().map(x -> x).collect(Collectors.toList());
        if (libraries == null || libraries.isEmpty()) {
            return null;
        }
        return this.libraryVersionSelector.select(libraryIdentifier, libraries);
    }
}

