/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.fhir.searchparam;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.api.SortOrderEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.QuantityParam;
import ca.uhn.fhir.util.ObjectUtil;
import ca.uhn.fhir.util.UrlUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchParameterMap
implements Serializable {
    private static final Logger ourLog = LoggerFactory.getLogger(SearchParameterMap.class);
    private final HashMap<String, List<List<IQueryParameterType>>> mySearchParameterMap = new LinkedHashMap<String, List<List<IQueryParameterType>>>();
    private static final long serialVersionUID = 1L;
    private Integer myCount;
    private EverythingModeEnum myEverythingMode = null;
    private Set<Include> myIncludes;
    private DateRangeParam myLastUpdated;
    private boolean myLoadSynchronous;
    private Integer myLoadSynchronousUpTo;
    private Set<Include> myRevIncludes;
    private SortSpec mySort;
    private SummaryEnum mySummaryMode;
    private SearchTotalModeEnum mySearchTotalMode;

    public SearchParameterMap() {
    }

    public SearchParameterMap(String theName, IQueryParameterType theParam) {
        this.add(theName, theParam);
    }

    public SummaryEnum getSummaryMode() {
        return this.mySummaryMode;
    }

    public void setSummaryMode(SummaryEnum theSummaryMode) {
        this.mySummaryMode = theSummaryMode;
    }

    public SearchTotalModeEnum getSearchTotalMode() {
        return this.mySearchTotalMode;
    }

    public void setSearchTotalMode(SearchTotalModeEnum theSearchTotalMode) {
        this.mySearchTotalMode = theSearchTotalMode;
    }

    public SearchParameterMap add(String theName, DateParam theDateParam) {
        this.add(theName, (IQueryParameterOr<?>)theDateParam);
        return this;
    }

    public void add(String theName, IQueryParameterAnd<?> theAnd) {
        if (theAnd == null) {
            return;
        }
        if (!this.containsKey(theName)) {
            this.put(theName, new ArrayList<List<IQueryParameterType>>());
        }
        for (IQueryParameterOr next : theAnd.getValuesAsQueryTokens()) {
            if (next == null) continue;
            this.get(theName).add(next.getValuesAsQueryTokens());
        }
    }

    public void add(String theName, IQueryParameterOr<?> theOr) {
        if (theOr == null) {
            return;
        }
        if (!this.containsKey(theName)) {
            this.put(theName, new ArrayList<List<IQueryParameterType>>());
        }
        this.get(theName).add(theOr.getValuesAsQueryTokens());
    }

    public Collection<List<List<IQueryParameterType>>> values() {
        return this.mySearchParameterMap.values();
    }

    public SearchParameterMap add(String theName, IQueryParameterType theParam) {
        assert (!"_lastUpdated".equals(theName));
        if (theParam == null) {
            return this;
        }
        if (!this.containsKey(theName)) {
            this.put(theName, new ArrayList<List<IQueryParameterType>>());
        }
        ArrayList<IQueryParameterType> list = new ArrayList<IQueryParameterType>();
        list.add(theParam);
        this.get(theName).add(list);
        return this;
    }

    public void addInclude(Include theInclude) {
        this.getIncludes().add(theInclude);
    }

    private void addLastUpdateParam(StringBuilder b, DateParam date) {
        if (date != null && StringUtils.isNotBlank((CharSequence)date.getValueAsString())) {
            this.addUrlParamSeparator(b);
            b.append("_lastUpdated");
            b.append('=');
            b.append(date.getValueAsString());
        }
    }

    public void addRevInclude(Include theInclude) {
        this.getRevIncludes().add(theInclude);
    }

    private void addUrlIncludeParams(StringBuilder b, String paramName, Set<Include> theList) {
        ArrayList<Include> list = new ArrayList<Include>(theList);
        list.sort(new IncludeComparator());
        for (Include nextInclude : list) {
            this.addUrlParamSeparator(b);
            b.append(paramName);
            b.append('=');
            b.append(UrlUtil.escapeUrlParam((String)nextInclude.getParamType()));
            b.append(':');
            b.append(UrlUtil.escapeUrlParam((String)nextInclude.getParamName()));
            if (!StringUtils.isNotBlank((CharSequence)nextInclude.getParamTargetType())) continue;
            b.append(':');
            b.append(nextInclude.getParamTargetType());
        }
    }

    private void addUrlParamSeparator(StringBuilder theB) {
        if (theB.length() == 0) {
            theB.append('?');
        } else {
            theB.append('&');
        }
    }

    public Integer getCount() {
        return this.myCount;
    }

    public void setCount(Integer theCount) {
        this.myCount = theCount;
    }

    public EverythingModeEnum getEverythingMode() {
        return this.myEverythingMode;
    }

    public void setEverythingMode(EverythingModeEnum theConsolidateMatches) {
        this.myEverythingMode = theConsolidateMatches;
    }

    public Set<Include> getIncludes() {
        if (this.myIncludes == null) {
            this.myIncludes = new HashSet<Include>();
        }
        return this.myIncludes;
    }

    public void setIncludes(Set<Include> theIncludes) {
        this.myIncludes = theIncludes;
    }

    public DateRangeParam getLastUpdated() {
        if (this.myLastUpdated != null && this.myLastUpdated.isEmpty()) {
            this.myLastUpdated = null;
        }
        return this.myLastUpdated;
    }

    public void setLastUpdated(DateRangeParam theLastUpdated) {
        this.myLastUpdated = theLastUpdated;
    }

    public Integer getLoadSynchronousUpTo() {
        return this.myLoadSynchronousUpTo;
    }

    public SearchParameterMap setLoadSynchronousUpTo(Integer theLoadSynchronousUpTo) {
        this.myLoadSynchronousUpTo = theLoadSynchronousUpTo;
        if (this.myLoadSynchronousUpTo != null) {
            this.setLoadSynchronous(true);
        }
        return this;
    }

    public Set<Include> getRevIncludes() {
        if (this.myRevIncludes == null) {
            this.myRevIncludes = new HashSet<Include>();
        }
        return this.myRevIncludes;
    }

    public void setRevIncludes(Set<Include> theRevIncludes) {
        this.myRevIncludes = theRevIncludes;
    }

    public SortSpec getSort() {
        return this.mySort;
    }

    public void setSort(SortSpec theSort) {
        this.mySort = theSort;
    }

    public boolean isAllParametersHaveNoModifier() {
        for (List<List<IQueryParameterType>> nextParamName : this.values()) {
            for (List<IQueryParameterType> nextAnd : nextParamName) {
                for (IQueryParameterType nextOr : nextAnd) {
                    if (!StringUtils.isNotBlank((CharSequence)nextOr.getQueryParameterQualifier())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isLoadSynchronous() {
        return this.myLoadSynchronous;
    }

    public SearchParameterMap setLoadSynchronous(boolean theLoadSynchronous) {
        this.myLoadSynchronous = theLoadSynchronous;
        return this;
    }

    public String toNormalizedQueryString(FhirContext theCtx) {
        StringBuilder b = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(this.keySet());
        Collections.sort(keys);
        for (String nextKey : keys) {
            List<List<IQueryParameterType>> nextValuesAndsIn = this.get(nextKey);
            ArrayList<List<Object>> nextValuesAndsOut = new ArrayList<List<Object>>();
            for (List<IQueryParameterType> nextValuesAndIn : nextValuesAndsIn) {
                ArrayList<IQueryParameterType> nextValuesOrsOut = new ArrayList<IQueryParameterType>();
                for (IQueryParameterType nextValueOrIn : nextValuesAndIn) {
                    if (nextValueOrIn.getMissing() == null && !StringUtils.isNotBlank((CharSequence)nextValueOrIn.getValueAsQueryToken(theCtx))) continue;
                    nextValuesOrsOut.add(nextValueOrIn);
                }
                nextValuesOrsOut.sort(new QueryParameterTypeComparator(theCtx));
                if (nextValuesOrsOut.size() <= 0) continue;
                nextValuesAndsOut.add(nextValuesOrsOut);
            }
            nextValuesAndsOut.sort(new QueryParameterOrComparator(theCtx));
            for (List<Object> nextValuesAnd : nextValuesAndsOut) {
                this.addUrlParamSeparator(b);
                IQueryParameterType firstValue = (IQueryParameterType)nextValuesAnd.get(0);
                b.append(UrlUtil.escapeUrlParam((String)nextKey));
                if (nextKey.equals("_has")) {
                    b.append(':');
                }
                if (firstValue.getMissing() != null) {
                    b.append(":missing");
                    b.append('=');
                    if (firstValue.getMissing().booleanValue()) {
                        b.append("true");
                        continue;
                    }
                    b.append("false");
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)firstValue.getQueryParameterQualifier())) {
                    b.append(firstValue.getQueryParameterQualifier());
                }
                b.append('=');
                for (int i = 0; i < nextValuesAnd.size(); ++i) {
                    IQueryParameterType nextValueOr = (IQueryParameterType)nextValuesAnd.get(i);
                    if (i > 0) {
                        b.append(',');
                    }
                    String valueAsQueryToken = nextValueOr.getValueAsQueryToken(theCtx);
                    b.append(UrlUtil.escapeUrlParam((String)valueAsQueryToken));
                }
            }
        }
        boolean first = true;
        for (SortSpec sort = this.getSort(); sort != null; sort = sort.getChain()) {
            if (StringUtils.isNotBlank((CharSequence)sort.getParamName())) {
                if (first) {
                    this.addUrlParamSeparator(b);
                    b.append("_sort");
                    b.append('=');
                    first = false;
                } else {
                    b.append(',');
                }
                if (sort.getOrder() == SortOrderEnum.DESC) {
                    b.append('-');
                }
                b.append(sort.getParamName());
            }
            Validate.isTrue((sort != sort.getChain() ? 1 : 0) != 0);
        }
        this.addUrlIncludeParams(b, "_include", this.getIncludes());
        this.addUrlIncludeParams(b, "_revinclude", this.getRevIncludes());
        if (this.getLastUpdated() != null) {
            DateParam lb = this.getLastUpdated().getLowerBound();
            this.addLastUpdateParam(b, lb);
            DateParam ub = this.getLastUpdated().getUpperBound();
            this.addLastUpdateParam(b, ub);
        }
        if (this.getCount() != null) {
            this.addUrlParamSeparator(b);
            b.append("_count");
            b.append('=');
            b.append(this.getCount());
        }
        if (this.getSummaryMode() != null) {
            this.addUrlParamSeparator(b);
            b.append("_summary");
            b.append('=');
            b.append(this.getSummaryMode().getCode());
        }
        if (this.getSearchTotalMode() != null) {
            this.addUrlParamSeparator(b);
            b.append("_total");
            b.append('=');
            b.append(this.getSearchTotalMode().getCode());
        }
        if (b.length() == 0) {
            b.append('?');
        }
        return b.toString();
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        if (!this.isEmpty()) {
            b.append("params", this.mySearchParameterMap);
        }
        if (!this.getIncludes().isEmpty()) {
            b.append("includes", this.getIncludes());
        }
        return b.toString();
    }

    public void clean() {
        for (Map.Entry<String, List<List<IQueryParameterType>>> nextParamEntry : this.entrySet()) {
            String nextParamName = nextParamEntry.getKey();
            List<List<IQueryParameterType>> andOrParams = nextParamEntry.getValue();
            this.clean(nextParamName, andOrParams);
        }
    }

    private void clean(String theParamName, List<List<IQueryParameterType>> theAndOrParams) {
        for (int andListIdx = 0; andListIdx < theAndOrParams.size(); ++andListIdx) {
            List<IQueryParameterType> nextOrList = theAndOrParams.get(andListIdx);
            for (int orListIdx = 0; orListIdx < nextOrList.size(); ++orListIdx) {
                IQueryParameterType nextOr = nextOrList.get(orListIdx);
                boolean hasNoValue = false;
                if (nextOr.getMissing() != null) continue;
                if (nextOr instanceof QuantityParam && StringUtils.isBlank((CharSequence)((QuantityParam)nextOr).getValueAsString())) {
                    hasNoValue = true;
                }
                if (!hasNoValue) continue;
                ourLog.debug("Ignoring empty parameter: {}", (Object)theParamName);
                nextOrList.remove(orListIdx);
                --orListIdx;
            }
            if (!nextOrList.isEmpty()) continue;
            theAndOrParams.remove(andListIdx);
            --andListIdx;
        }
    }

    private static int compare(FhirContext theCtx, IQueryParameterType theO1, IQueryParameterType theO2) {
        int retVal = theO1.getMissing() == null && theO2.getMissing() == null ? 0 : (theO1.getMissing() == null ? -1 : (theO2.getMissing() == null ? 1 : (ObjectUtil.equals((Object)theO1.getMissing(), (Object)theO2.getMissing()) ? 0 : (theO1.getMissing() != false ? 1 : -1))));
        if (retVal == 0) {
            String q1 = theO1.getQueryParameterQualifier();
            String q2 = theO2.getQueryParameterQualifier();
            retVal = StringUtils.compare((String)q1, (String)q2);
        }
        if (retVal == 0) {
            String v1 = theO1.getValueAsQueryToken(theCtx);
            String v2 = theO2.getValueAsQueryToken(theCtx);
            retVal = StringUtils.compare((String)v1, (String)v2);
        }
        return retVal;
    }

    public List<List<IQueryParameterType>> get(String theName) {
        return this.mySearchParameterMap.get(theName);
    }

    private void put(String theName, List<List<IQueryParameterType>> theParams) {
        this.mySearchParameterMap.put(theName, theParams);
    }

    public boolean containsKey(String theName) {
        return this.mySearchParameterMap.containsKey(theName);
    }

    public Set<String> keySet() {
        return this.mySearchParameterMap.keySet();
    }

    public boolean isEmpty() {
        return this.mySearchParameterMap.isEmpty();
    }

    public Set<Map.Entry<String, List<List<IQueryParameterType>>>> entrySet() {
        return this.mySearchParameterMap.entrySet();
    }

    public List<List<IQueryParameterType>> remove(String theName) {
        return this.mySearchParameterMap.remove(theName);
    }

    public class QueryParameterTypeComparator
    implements Comparator<IQueryParameterType> {
        private final FhirContext myCtx;

        QueryParameterTypeComparator(FhirContext theCtx) {
            this.myCtx = theCtx;
        }

        @Override
        public int compare(IQueryParameterType theO1, IQueryParameterType theO2) {
            return SearchParameterMap.compare(this.myCtx, theO1, theO2);
        }
    }

    public class QueryParameterOrComparator
    implements Comparator<List<IQueryParameterType>> {
        private final FhirContext myCtx;

        QueryParameterOrComparator(FhirContext theCtx) {
            this.myCtx = theCtx;
        }

        @Override
        public int compare(List<IQueryParameterType> theO1, List<IQueryParameterType> theO2) {
            return SearchParameterMap.compare(this.myCtx, theO1.get(0), theO2.get(0));
        }
    }

    public class IncludeComparator
    implements Comparator<Include> {
        @Override
        public int compare(Include theO1, Include theO2) {
            int retVal = StringUtils.compare((String)theO1.getParamType(), (String)theO2.getParamType());
            if (retVal == 0) {
                retVal = StringUtils.compare((String)theO1.getParamName(), (String)theO2.getParamName());
            }
            if (retVal == 0) {
                retVal = StringUtils.compare((String)theO1.getParamTargetType(), (String)theO2.getParamTargetType());
            }
            return retVal;
        }
    }

    public static final class EverythingModeEnum
    extends Enum<EverythingModeEnum> {
        public static final /* enum */ EverythingModeEnum ENCOUNTER_INSTANCE = new EverythingModeEnum(false, true, true);
        public static final /* enum */ EverythingModeEnum ENCOUNTER_TYPE = new EverythingModeEnum(false, true, false);
        public static final /* enum */ EverythingModeEnum PATIENT_INSTANCE = new EverythingModeEnum(true, false, true);
        public static final /* enum */ EverythingModeEnum PATIENT_TYPE = new EverythingModeEnum(true, false, false);
        private final boolean myEncounter;
        private final boolean myInstance;
        private final boolean myPatient;
        private static final /* synthetic */ EverythingModeEnum[] $VALUES;

        public static EverythingModeEnum[] values() {
            return (EverythingModeEnum[])$VALUES.clone();
        }

        public static EverythingModeEnum valueOf(String name) {
            return Enum.valueOf(EverythingModeEnum.class, name);
        }

        private EverythingModeEnum(boolean thePatient, boolean theEncounter, boolean theInstance) {
            assert (thePatient ^ theEncounter);
            this.myPatient = thePatient;
            this.myEncounter = theEncounter;
            this.myInstance = theInstance;
        }

        public boolean isEncounter() {
            return this.myEncounter;
        }

        public boolean isInstance() {
            return this.myInstance;
        }

        public boolean isPatient() {
            return this.myPatient;
        }

        static {
            $VALUES = new EverythingModeEnum[]{ENCOUNTER_INSTANCE, ENCOUNTER_TYPE, PATIENT_INSTANCE, PATIENT_TYPE};
        }
    }
}

