/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgprouter;

import java.util.Optional;
import java.util.Set;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IPv4;
import org.onlab.packet.IpAddress;
import org.onlab.packet.TCP;
import org.onlab.packet.TpPort;
import org.onosproject.core.ApplicationId;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.packet.DefaultOutboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.onosproject.routing.config.BgpConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunnellingConnectivityManager {
    private static final short BGP_PORT = 179;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ApplicationId appId;
    private final BgpConfig.BgpSpeakerConfig bgpSpeaker;
    private final PacketService packetService;
    private final InterfaceService interfaceService;
    private final FlowObjectiveService flowObjectiveService;
    private final BgpProcessor processor = new BgpProcessor();

    public TunnellingConnectivityManager(ApplicationId appId, BgpConfig bgpConfig, InterfaceService interfaceService, PacketService packetService, FlowObjectiveService flowObjectiveService) {
        this.appId = appId;
        this.interfaceService = interfaceService;
        this.packetService = packetService;
        this.flowObjectiveService = flowObjectiveService;
        Optional bgpSpeaker = bgpConfig.bgpSpeakers().stream().findAny();
        if (!bgpSpeaker.isPresent()) {
            throw new IllegalArgumentException("Must have at least one BGP speaker configured");
        }
        this.bgpSpeaker = (BgpConfig.BgpSpeakerConfig)bgpSpeaker.get();
    }

    public void start() {
        this.packetService.addProcessor((PacketProcessor)this.processor, PacketProcessor.director((int)3));
    }

    public void stop() {
        this.packetService.removeProcessor((PacketProcessor)this.processor);
    }

    public void notifySwitchAvailable() {
        TrafficSelector selectorDst = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchIPProtocol((byte)6).matchTcpDst(TpPort.tpPort((int)179)).build();
        TrafficSelector selectorSrc = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchIPProtocol((byte)6).matchTcpSrc(TpPort.tpPort((int)179)).build();
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().punt().build();
        ForwardingObjective puntSrc = DefaultForwardingObjective.builder().fromApp(this.appId).makePermanent().withSelector(selectorSrc).withTreatment(treatment).withFlag(ForwardingObjective.Flag.VERSATILE).add();
        this.flowObjectiveService.forward(this.bgpSpeaker.connectPoint().deviceId(), puntSrc);
        ForwardingObjective puntDst = DefaultForwardingObjective.builder().fromApp(this.appId).makePermanent().withSelector(selectorDst).withTreatment(treatment).withFlag(ForwardingObjective.Flag.VERSATILE).add();
        this.flowObjectiveService.forward(this.bgpSpeaker.connectPoint().deviceId(), puntDst);
        this.log.info("Sent punt forwarding objective to {}", (Object)this.bgpSpeaker.connectPoint().deviceId());
    }

    private void forward(PacketContext context) {
        ConnectPoint outputPort = null;
        IPv4 ipv4 = (IPv4)context.inPacket().parsed().getPayload();
        IpAddress dstAddress = IpAddress.valueOf((int)ipv4.getDestinationAddress());
        if (context.inPacket().receivedFrom().equals((Object)this.bgpSpeaker.connectPoint())) {
            Interface intf2;
            if (this.bgpSpeaker.peers().contains(dstAddress) && (intf2 = this.interfaceService.getMatchingInterface(dstAddress)) != null) {
                outputPort = intf2.connectPoint();
            }
        } else {
            Set interfaces = this.interfaceService.getInterfacesByPort(context.inPacket().receivedFrom());
            if (interfaces.stream().flatMap(intf -> intf.ipAddresses().stream()).anyMatch(ia -> ia.ipAddress().equals((Object)dstAddress))) {
                outputPort = this.bgpSpeaker.connectPoint();
            }
        }
        if (outputPort != null) {
            TrafficTreatment t = DefaultTrafficTreatment.builder().setOutput(outputPort.port()).build();
            DefaultOutboundPacket o = new DefaultOutboundPacket(outputPort.deviceId(), t, context.inPacket().unparsed());
            this.packetService.emit((OutboundPacket)o);
        }
    }

    private class BgpProcessor
    implements PacketProcessor {
        private BgpProcessor() {
        }

        public void process(PacketContext context) {
            TCP tcpPacket;
            IPv4 ipv4Packet;
            if (context.isHandled()) {
                return;
            }
            Ethernet packet = context.inPacket().parsed();
            if (packet == null) {
                return;
            }
            if (packet.getEtherType() == Ethernet.TYPE_IPV4 && (ipv4Packet = (IPv4)packet.getPayload()).getProtocol() == 6 && ((tcpPacket = (TCP)ipv4Packet.getPayload()).getDestinationPort() == 179 || tcpPacket.getSourcePort() == 179)) {
                TunnellingConnectivityManager.this.forward(context);
            }
        }
    }
}

