/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgprouter;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.bgprouter.IcmpHandler;
import org.onosproject.bgprouter.TunnellingConnectivityManager;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.component.ComponentService;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.packet.PacketService;
import org.onosproject.routing.RoutingService;
import org.onosproject.routing.config.BgpConfig;
import org.onosproject.routing.config.RoutingConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class BgpRouter {
    private static final Logger log = LoggerFactory.getLogger(BgpRouter.class);
    public static final String BGP_ROUTER_APP = "org.onosproject.bgprouter";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected RoutingConfigurationService routingConfigurationService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected InterfaceService interfaceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigService networkConfigService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowObjectiveService flowObjectiveService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentService componentService;
    private ApplicationId appId;
    private DeviceId ctrlDeviceId;
    private TunnellingConnectivityManager connectivityManager;
    private DeviceListener deviceListener;
    private IcmpHandler icmpHandler;
    private static List<String> components = new ArrayList<String>();

    @Activate
    protected void activate() {
        this.appId = this.coreService.registerApplication(BGP_ROUTER_APP);
        components.forEach(name -> this.componentService.activate(this.appId, name));
        ApplicationId routerAppId = this.coreService.getAppId("org.onosproject.router");
        BgpConfig bgpConfig = (BgpConfig)this.networkConfigService.getConfig((Object)routerAppId, RoutingService.CONFIG_CLASS);
        if (bgpConfig == null) {
            log.error("No BgpConfig found");
            return;
        }
        this.getDeviceConfiguration(bgpConfig);
        this.connectivityManager = new TunnellingConnectivityManager(this.appId, bgpConfig, this.interfaceService, this.packetService, this.flowObjectiveService);
        this.icmpHandler = new IcmpHandler(this.interfaceService, this.packetService);
        this.deviceListener = new InnerDeviceListener();
        this.deviceService.addListener((EventListener)this.deviceListener);
        this.connectivityManager.start();
        this.icmpHandler.start();
        if (this.deviceService.isAvailable(this.ctrlDeviceId)) {
            this.connectivityManager.notifySwitchAvailable();
        }
        log.info("BgpRouter started");
    }

    @Deactivate
    protected void deactivate() {
        components.forEach(name -> this.componentService.deactivate(this.appId, name));
        this.connectivityManager.stop();
        this.icmpHandler.stop();
        this.deviceService.removeListener((EventListener)this.deviceListener);
        log.info("BgpRouter stopped");
    }

    private void getDeviceConfiguration(BgpConfig bgpConfig) {
        Optional bgpSpeaker = bgpConfig.bgpSpeakers().stream().findAny();
        if (!bgpSpeaker.isPresent()) {
            log.error("BGP speaker configuration not found");
            return;
        }
        this.ctrlDeviceId = ((BgpConfig.BgpSpeakerConfig)bgpSpeaker.get()).connectPoint().deviceId();
        log.info("Control Plane OVS dpid: {}", (Object)this.ctrlDeviceId);
    }

    static {
        components.add("org.onosproject.routing.bgp.BgpSessionManager");
        components.add("org.onosproject.routing.impl.Router");
        components.add("org.onosproject.routing.impl.SingleSwitchFibInstaller");
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindRoutingConfigurationService(RoutingConfigurationService routingConfigurationService) {
        this.routingConfigurationService = routingConfigurationService;
    }

    protected void unbindRoutingConfigurationService(RoutingConfigurationService routingConfigurationService) {
        if (this.routingConfigurationService == routingConfigurationService) {
            this.routingConfigurationService = null;
        }
    }

    protected void bindInterfaceService(InterfaceService interfaceService) {
        this.interfaceService = interfaceService;
    }

    protected void unbindInterfaceService(InterfaceService interfaceService) {
        if (this.interfaceService == interfaceService) {
            this.interfaceService = null;
        }
    }

    protected void bindNetworkConfigService(NetworkConfigService networkConfigService) {
        this.networkConfigService = networkConfigService;
    }

    protected void unbindNetworkConfigService(NetworkConfigService networkConfigService) {
        if (this.networkConfigService == networkConfigService) {
            this.networkConfigService = null;
        }
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        this.flowObjectiveService = flowObjectiveService;
    }

    protected void unbindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        if (this.flowObjectiveService == flowObjectiveService) {
            this.flowObjectiveService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindComponentService(ComponentService componentService) {
        this.componentService = componentService;
    }

    protected void unbindComponentService(ComponentService componentService) {
        if (this.componentService == componentService) {
            this.componentService = null;
        }
    }

    private class InnerDeviceListener
    implements DeviceListener {
        private InnerDeviceListener() {
        }

        public void event(DeviceEvent event) {
            switch ((DeviceEvent.Type)event.type()) {
                case DEVICE_ADDED: 
                case DEVICE_AVAILABILITY_CHANGED: {
                    if (!BgpRouter.this.deviceService.isAvailable(((Device)event.subject()).id())) break;
                    log.info("Device connected {}", (Object)((Device)event.subject()).id());
                    if (!((Device)event.subject()).id().equals((Object)BgpRouter.this.ctrlDeviceId)) break;
                    BgpRouter.this.connectivityManager.notifySwitchAvailable();
                    break;
                }
            }
        }
    }
}

